/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;

public class InMemoryConnectionServiceImpl
implements IConnectionService {
    private List<IDatabaseConnection> connectionList = new ArrayList<IDatabaseConnection>();
    private static final Log logger = LogFactory.getLog(InMemoryConnectionServiceImpl.class);

    @Override
    public List<IDatabaseConnection> getConnections() throws ConnectionServiceException {
        return this.connectionList;
    }

    @Override
    public IDatabaseConnection getConnectionByName(String name) throws ConnectionServiceException {
        for (IDatabaseConnection connection : this.connectionList) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, null));
    }

    @Override
    public boolean addConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        if (!this.isConnectionExist(connection.getName())) {
            this.connectionList.add(connection);
            return true;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), null));
    }

    @Override
    public boolean updateConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        IDatabaseConnection conn = this.getConnectionByName(connection.getName());
        if (conn != null) {
            conn.setAccessType(connection.getAccessType());
            conn.setPassword(connection.getPassword());
            conn.setUsername(connection.getUsername());
            return true;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), null));
    }

    @Override
    public boolean deleteConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.connectionList.remove(this.connectionList.indexOf(connection));
        return true;
    }

    @Override
    public boolean deleteConnection(String name) throws ConnectionServiceException {
        for (IDatabaseConnection connection : this.connectionList) {
            if (!connection.getName().equals(name)) continue;
            return this.deleteConnection(connection);
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, null));
    }

    @Override
    public boolean testConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        Connection conn = null;
        try {
            conn = InMemoryConnectionServiceImpl.getConnection(connection);
        }
        catch (ConnectionServiceException dme) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), dme.getLocalizedMessage()), (Throwable)dme);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), dme.getLocalizedMessage()), dme);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), null));
                throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), null));
            }
        }
        return true;
    }

    private static Connection getConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        Connection conn = null;
        String driverClass = connection.getAccessType().getClass().toString();
        if (StringUtils.isEmpty((String)driverClass)) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0020_CONNECTION_ATTEMPT_FAILED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0020_CONNECTION_ATTEMPT_FAILED"));
        }
        Class<?> driverC = null;
        try {
            driverC = Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH"), e);
        }
        if (!Driver.class.isAssignableFrom(driverC)) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH", driverClass));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH"));
        }
        Driver driver = null;
        try {
            driver = driverC.asSubclass(Driver.class).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER"), e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER"), e);
        }
        try {
            DriverManager.registerDriver(driver);
            DatabaseDialectService dialectService = new DatabaseDialectService();
            IDatabaseDialect dialect = dialectService.getDialect(connection);
            conn = DriverManager.getConnection(dialect.getURLWithExtraOptions(connection), connection.getUsername(), connection.getPassword());
            return conn;
        }
        catch (SQLException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), e);
        }
        catch (DatabaseDialectException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), e);
        }
    }

    @Override
    public boolean isConnectionExist(String connectionName) {
        for (IDatabaseConnection connection : this.connectionList) {
            if (!connection.getName().equals(connectionName)) continue;
            return true;
        }
        return false;
    }
}

