/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.beans.BogoPojo;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.CsvUtils;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvTransformGeneratorException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.models.FileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.CsvTransformGenerator;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class CsvDatasourceServiceImpl
extends PentahoBase
implements ICsvDatasourceService {
    public static final byte[] lock = new byte[0];
    private static final long serialVersionUID = 2498165533158485182L;
    private Log logger = LogFactory.getLog(CsvDatasourceServiceImpl.class);
    private ModelerService modelerService = new ModelerService();
    private DSWDatasourceServiceImpl datasourceService = new DSWDatasourceServiceImpl();
    private ModelerWorkspace modelerWorkspace = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper());

    public CsvDatasourceServiceImpl() {
        try {
            this.modelerWorkspace.setGeoContext(this.datasourceService.getGeoContext());
        }
        catch (DatasourceServiceException e) {
            this.logger.warn((Object)"Could not get a GeoContext, auto-modeling will not use be able to auto detect geographies", (Throwable)e);
        }
        this.modelerService = new ModelerService();
    }

    public Log getLogger() {
        return this.logger;
    }

    @Override
    public String getEncoding(String fileName) {
        String encoding = null;
        try {
            CsvUtils csvModelService = new CsvUtils();
            encoding = csvModelService.getEncoding(fileName);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return encoding;
    }

    @Override
    public ModelInfo stageFile(String fileName, String delimiter, String enclosure, boolean isFirstRowHeader, String encoding) throws Exception {
        ModelInfo modelInfo;
        try {
            CsvUtils csvModelService = new CsvUtils();
            int headerRows = isFirstRowHeader ? 1 : 0;
            modelInfo = csvModelService.generateFields("", fileName, AgileHelper.getCsvSampleRowSize(), delimiter, enclosure, headerRows, true, true, encoding);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw e;
        }
        return modelInfo;
    }

    @Override
    public FileInfo[] getStagedFiles() throws Exception {
        FileInfo[] files;
        try {
            org.pentaho.platform.dataaccess.datasource.wizard.csv.FileUtils fileService = new org.pentaho.platform.dataaccess.datasource.wizard.csv.FileUtils();
            files = fileService.listFiles();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw e;
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileTransformStats generateDomain(DatasourceDTO datasourceDto) throws Exception {
        byte[] byArray = lock;
        synchronized (lock) {
            ModelInfo modelInfo = datasourceDto.getCsvModelInfo();
            IPentahoSession pentahoSession = null;
            try {
                pentahoSession = PentahoSessionHolder.getSession();
                KettleSystemListener.environmentInit((IPentahoSession)pentahoSession);
                String statsKey = FileTransformStats.class.getSimpleName() + "_" + modelInfo.getFileInfo().getTmpFilename();
                FileTransformStats stats = new FileTransformStats();
                pentahoSession.setAttribute(statsKey, (Object)stats);
                CsvTransformGenerator csvTransformGenerator = new CsvTransformGenerator(modelInfo, AgileHelper.getDatabaseMeta());
                csvTransformGenerator.setTransformStats(stats);
                try {
                    csvTransformGenerator.dropTable(modelInfo.getStageTableName());
                }
                catch (CsvTransformGeneratorException e) {
                    this.logger.info((Object)"Could not drop table before staging");
                }
                csvTransformGenerator.createOrModifyTable(pentahoSession);
                csvTransformGenerator.loadTable(false, pentahoSession, true);
                ArrayList<String> combinedErrors = new ArrayList<String>(modelInfo.getCsvInputErrors());
                combinedErrors.addAll(modelInfo.getTableOutputErrors());
                stats.setErrors(combinedErrors);
                while (!stats.isRowsFinished()) {
                    Thread.sleep(200L);
                }
                this.modelerWorkspace.setDomain(this.modelerService.generateCSVDomain(modelInfo.getStageTableName(), modelInfo.getDatasourceName()));
                this.modelerWorkspace.getWorkspaceHelper().autoModelFlat(this.modelerWorkspace);
                this.modelerWorkspace.getWorkspaceHelper().autoModelRelationalFlat(this.modelerWorkspace);
                this.modelerWorkspace.setModelName(modelInfo.getDatasourceName());
                this.modelerWorkspace.getWorkspaceHelper().populateDomain(this.modelerWorkspace);
                Domain workspaceDomain = this.modelerWorkspace.getDomain();
                XStream xstream = new XStream();
                String serializedDto = xstream.toXML((Object)datasourceDto);
                ((LogicalModel)workspaceDomain.getLogicalModels().get(0)).setProperty("datasourceModel", (Object)serializedDto);
                ((LogicalModel)workspaceDomain.getLogicalModels().get(0)).setProperty("DatasourceType", (Object)"CSV");
                this.prepareForSerialization(workspaceDomain);
                this.modelerService.serializeModels(workspaceDomain, this.modelerWorkspace.getModelName());
                stats.setDomain(this.modelerWorkspace.getDomain());
                FileTransformStats fileTransformStats = stats;
                // ** MonitorExit[byArray] (shouldn't be in output)
                return fileTransformStats;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw e;
            }
            finally {
                if (pentahoSession != null) {
                    pentahoSession.destroy();
                }
            }
        }
    }

    protected void prepareForSerialization(Domain domain) throws IOException {
        String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(org.pentaho.platform.dataaccess.datasource.wizard.csv.FileUtils.DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + File.separatorChar + "tmp" + File.separatorChar;
        String sysTmpDir = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
        LogicalModel logicalModel = (LogicalModel)domain.getLogicalModels().get(0);
        String modelState = (String)logicalModel.getProperty("datasourceModel");
        if (modelState != null) {
            XStream xs = new XStream();
            DatasourceDTO datasource = (DatasourceDTO)xs.fromXML(modelState);
            CsvFileInfo csvFileInfo = datasource.getCsvModelInfo().getFileInfo();
            String tmpFileName = csvFileInfo.getTmpFilename();
            String csvFileName = csvFileInfo.getFilename();
            File tmpFile = new File(sysTmpDir + File.separatorChar + tmpFileName);
            if (tmpFile.exists()) {
                File csvFile = new File(path + File.separatorChar + csvFileName);
                FileUtils.copyFile((File)tmpFile, (File)csvFile);
            }
            datasource.setQuery(null);
            modelState = xs.toXML((Object)datasource);
            logicalModel.setProperty("datasourceModel", (Object)modelState);
        }
    }

    @Override
    public List<String> getPreviewRows(String filename, boolean isFirstRowHeader, int rows, String encoding) throws Exception {
        List<String> previewRows = null;
        if (!StringUtils.isEmpty((String)filename)) {
            CsvUtils service = new CsvUtils();
            ModelInfo mi = service.getFileContents("", filename, ",", "\"", rows, isFirstRowHeader, encoding);
            previewRows = mi.getFileInfo().getContents();
        }
        return previewRows;
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }
}

