/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.api.resources.AnalysisResource;
import org.pentaho.platform.web.http.api.resources.JaxbList;

@Path(value="/data-access/api/datasource/analysis")
public class AnalysisDatasourceService
extends AnalysisResource {
    @GET
    @Path(value="/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getAnalysisDatasourceIds() {
        return new AnalysisResource().getSchemaIds();
    }

    @GET
    @Path(value="/{catalog : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully downloaded the analysis file"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=500, condition="Unabled to download analysis file")})
    public Response doGetAnalysisFilesAsDownload(@PathParam(value="catalog") String catalog) {
        return new AnalysisResource().downloadSchema(catalog);
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Status code indicating a success or failure while importing Mondrian schema XML. A response of:\n   *  2: Unspecified general error has occurred\n   *  3: Success\n   *  5: Authorization error")})
    public Response putMondrianSchema(@FormDataParam(value="uploadInput") InputStream uploadAnalysis, @FormDataParam(value="uploadInput") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogId") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters) throws PentahoAccessControlException {
        return super.importMondrianSchema(uploadAnalysis, schemaFileInfo, catalogName, origCatalogName, datasourceName, overwrite, xmlaEnabledFlag, parameters);
    }

    @POST
    @Path(value="/{catalog : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully removed the analysis data"), @ResponseCode(code=401, condition="User is not authorized to delete the analysis datasource"), @ResponseCode(code=500, condition="Unable to remove the analysis data.")})
    public Response doRemoveAnalysis(@PathParam(value="catalog") String catalog) {
        try {
            this.service.removeAnalysis(catalog);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
    }
}

