/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.AgileMartDatasourceLifecycleManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class AgileMartDatasourceHelper {
    private IPluginResourceLoader resLoader;
    private static final String AGILEMART_STAGING_PROPERTIES_FILE = "agile_mart_datasource.properties";
    public static final String NAME = "name";
    public static final String DEFAULT_NAME_VALUE = "AgileBI";
    public static final String ACCESS_TYPE = "accessType";
    public static final String DEFAULT_ACCESS_TYPE_VALUE = "NATIVE";
    public static final String CHANGED = "changed";
    public static final String DEFAULT_CHANGED_VALUE = "NATIVE";
    public static final String DATABASENAME = "databaseName";
    public static final String DEFAULT_DATABASENAME_VALUE = "pentaho-instaview";
    public static final String DATABASEPORT = "databasePort";
    public static final String DEFAULT_DATABASEPORT_VALUE = "50000";
    public static final String DEFAULTDATABASEPORT = "databaseType.defaultDatabasePort";
    public static final String DEFAULT_DEFAULTDATABASEPORT_VALUE = "50000";
    public static final String DATABASETYPENAME = "databaseType.name";
    public static final String DEFAULT_DATABASETYPENAME_VALUE = "monetdb";
    public static final String DATABASETYPESHORTNAME = "databaseType.shortName";
    public static final String DEFAULT_DATABASETYPESHORTNAME_VALUE = "MONETDB";
    public static final String FORCINGIDENTIFIERSTOLOWERCASE = "forcingIdentifiersToLowerCase";
    public static final String DEFAULT_FORCINGIDENTIFIERSTOLOWERCASE_VALUE = "false";
    public static final String FORCINGIDENTIFIERSTOUPPERCASE = "forcingIdentifiersToUpperCase";
    public static final String DEFAULT_FORCINGIDENTIFIERSTOUPPERCASE_VALUE = "false";
    public static final String HOSTNAME = "hostname";
    public static final String DEFAULT_HOSTNAME_VALUE = "localhost";
    public static final String USERNAME = "username";
    public static final String DEFAULT_USERNAME_VALUE = "monetdb";
    public static final String PASSWORD = "password";
    public static final String DEFAULT_PASSWORD_VALUE = "monetdb";
    public static final String INITIALPOOLSIZE = "initialPoolSize";
    public static final String DEFAULT_INITIALPOOLSIZE_VALUE = "0";
    public static final String MAXIMUMPOOLSIZE = "maximumPoolSize";
    public static final String DEFAULT_MAXIMUMPOOLSIZE_VALUE = "0";
    public static final String PARTITIONED = "partitioned";
    public static final String DEFAULT_PARTITIONED_VALUE = "false";
    public static final String QUOTEALLFIELDS = "quoteAllFields";
    public static final String DEFAULT_QUOTEALLFIELDS_VALUE = "false";
    public static final String STREAMINGRESULTS = "streamingResults";
    public static final String DEFAULT_STREAMINGRESULTS_VALUE = "false";
    public static final String USECONNECTIONPOOL = "usingConnectionPool";
    public static final String DEFAULT_USECONNECTIONPOOL_VALUE = "false";
    public static final String USINGDOUBLEDECIMALASSCHEMATABLESEPERATOR = "usingDoubleDecimalAsSchemaTableSeparator";
    public static final String DEFAULT_USINGDOUBLEDECIMALASSCHEMATABLESEPERATOR_VALUE = "false";
    private static final String ATTRIBUTE_PORT_NUMBER = "PORT_NUMBER";
    public static final String ATTRIBUTE_STANDARD_CONNECTION = "STANDARD_CONNECTION";
    public static final String ATTRIBUTE_AGILE_MART_CONNECTION = "AGILE_MART_CONNECTION";

    public AgileMartDatasourceHelper(IPluginResourceLoader resLoader) {
        this.resLoader = resLoader;
    }

    public IDatabaseConnection getAgileMartDatasource() {
        InputStream inputStream = this.resLoader.getResourceAsStream(AgileMartDatasourceLifecycleManager.class, AGILEMART_STAGING_PROPERTIES_FILE);
        Properties agileMartDatasourceProperties = new Properties();
        try {
            agileMartDatasourceProperties.load(inputStream);
            return this.getAgileMartDatasource(false, agileMartDatasourceProperties);
        }
        catch (IOException e) {
            return this.getAgileMartDatasource(true, agileMartDatasourceProperties);
        }
    }

    private IDatabaseConnection getAgileMartDatasource(Boolean useDefault, Properties agileMartDatasourceProperties) {
        String accessType;
        DatabaseConnection databaseConnection = new DatabaseConnection();
        IDatabaseDialectService databaseDialectService = (IDatabaseDialectService)PentahoSystem.get(IDatabaseDialectService.class);
        DatabaseTypeHelper databaseTypeHelper = new DatabaseTypeHelper(databaseDialectService.getDatabaseTypes());
        databaseConnection.setDatabaseType(databaseTypeHelper.getDatabaseTypeByShortName(useDefault != false ? agileMartDatasourceProperties.getProperty(DEFAULT_DATABASETYPESHORTNAME_VALUE) : agileMartDatasourceProperties.getProperty(DATABASETYPESHORTNAME)));
        String string = accessType = useDefault != false ? agileMartDatasourceProperties.getProperty("NATIVE") : agileMartDatasourceProperties.getProperty(ACCESS_TYPE);
        if (accessType != null && accessType.contains("Native") || accessType.equals("NATIVE")) {
            accessType = DatabaseAccessType.NATIVE.getName();
        } else if (accessType != null && accessType.equals(", ")) {
            accessType = DatabaseAccessType.JNDI.getName();
        }
        databaseConnection.setAccessType(accessType != null ? DatabaseAccessType.getAccessTypeByName((String)accessType) : null);
        databaseConnection.setName(useDefault != false ? agileMartDatasourceProperties.getProperty(DEFAULT_NAME_VALUE) : agileMartDatasourceProperties.getProperty(NAME));
        databaseConnection.setChanged(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("NATIVE") : agileMartDatasourceProperties.getProperty(CHANGED)));
        databaseConnection.setDatabaseName(useDefault != false ? agileMartDatasourceProperties.getProperty(DEFAULT_DATABASENAME_VALUE) : agileMartDatasourceProperties.getProperty(DATABASENAME));
        databaseConnection.setDatabasePort(useDefault != false ? agileMartDatasourceProperties.getProperty("50000") : agileMartDatasourceProperties.getProperty(DATABASEPORT));
        databaseConnection.setForcingIdentifiersToLowerCase(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("false") : agileMartDatasourceProperties.getProperty(FORCINGIDENTIFIERSTOLOWERCASE)));
        databaseConnection.setForcingIdentifiersToUpperCase(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("false") : agileMartDatasourceProperties.getProperty(FORCINGIDENTIFIERSTOUPPERCASE)));
        databaseConnection.setHostname(useDefault != false ? agileMartDatasourceProperties.getProperty(DEFAULT_HOSTNAME_VALUE) : agileMartDatasourceProperties.getProperty(HOSTNAME));
        databaseConnection.setInitialPoolSize(Integer.valueOf(useDefault != false ? agileMartDatasourceProperties.getProperty("0") : agileMartDatasourceProperties.getProperty(INITIALPOOLSIZE)).intValue());
        databaseConnection.setMaximumPoolSize(Integer.valueOf(useDefault != false ? agileMartDatasourceProperties.getProperty("0") : agileMartDatasourceProperties.getProperty(MAXIMUMPOOLSIZE)).intValue());
        databaseConnection.setPartitioned(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("false") : agileMartDatasourceProperties.getProperty(PARTITIONED)));
        databaseConnection.setPassword(useDefault != false ? agileMartDatasourceProperties.getProperty("monetdb") : agileMartDatasourceProperties.getProperty(PASSWORD));
        databaseConnection.setUsername(useDefault != false ? agileMartDatasourceProperties.getProperty("monetdb") : agileMartDatasourceProperties.getProperty(USERNAME));
        databaseConnection.setUsingConnectionPool(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("false") : agileMartDatasourceProperties.getProperty(USECONNECTIONPOOL)));
        databaseConnection.setUsingDoubleDecimalAsSchemaTableSeparator(Boolean.getBoolean(useDefault != false ? agileMartDatasourceProperties.getProperty("false") : agileMartDatasourceProperties.getProperty(USINGDOUBLEDECIMALASSCHEMATABLESEPERATOR)));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ATTRIBUTE_PORT_NUMBER, useDefault != false ? agileMartDatasourceProperties.getProperty("50000") : agileMartDatasourceProperties.getProperty(DATABASEPORT));
        attributes.put(ATTRIBUTE_STANDARD_CONNECTION, Boolean.FALSE.toString());
        attributes.put(ATTRIBUTE_AGILE_MART_CONNECTION, Boolean.TRUE.toString());
        databaseConnection.setAttributes(attributes);
        return databaseConnection;
    }
}

