/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ColumnInfo
extends XulEventSourceAdapter
implements Serializable {
    public static final List<String> DATE_FORMATS = Arrays.asList("MM-dd-yyyy", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "MM-dd-yy", "MM/dd/yy", "dd-MM-yy", "dd/MM/yy");
    private static final long serialVersionUID = 2498345633158485182L;
    public static final String FIELD_TYPE_BOTH = "both";
    public static final String FIELD_TYPE_MEASURE = "measure";
    public static final String FIELD_TYPE_ATTRIBUTE = "attribute";
    public static final String FIELD_TYPE_DIMENSION = "dimension";
    public static final int DATE_LEVEL_YEAR = 1;
    public static final int DATE_LEVEL_MONTH = 2;
    public static final int DATE_LEVEL_QUARTER = 4;
    public static final int DATE_LEVEL_WEEK = 8;
    public static final int DATE_LEVEL_DAY = 16;
    public static final int DATE_LEVEL_DAYOFWEEK = 32;
    private String id;
    private String title;
    private DataType dataType;
    private static List<DataType> availableDataTypes;
    private String aggregateType;
    private String[] samples;
    private boolean index;
    private boolean ignore;
    private String fieldType;
    private String format;
    private int length;
    private int precision;
    private int dateFieldBreakout = 63;

    @Bindable
    public int getLength() {
        return this.length;
    }

    @Bindable
    public void setLength(int length) {
        this.length = length;
    }

    @Bindable
    public int getPrecision() {
        return this.precision;
    }

    @Bindable
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Bindable
    public String getFormat() {
        return this.format;
    }

    @Bindable
    public void setFormat(String format) {
        this.format = format;
    }

    @Bindable
    public boolean isIndex() {
        return this.index;
    }

    @Bindable
    public void setIndex(boolean index) {
        this.index = index;
    }

    @Bindable
    public boolean isIgnore() {
        return this.ignore;
    }

    @Bindable
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Bindable
    public boolean isInclude() {
        return !this.ignore;
    }

    @Bindable
    public void setInclude(boolean include) {
        this.ignore = !include;
        this.firePropertyChange("include", null, include);
    }

    @Bindable
    public String getFieldType() {
        return this.fieldType;
    }

    @Bindable
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @Bindable
    public String getId() {
        return this.id;
    }

    @Bindable
    public void setId(String id) {
        this.id = id;
    }

    @Bindable
    public String getTitle() {
        return this.title;
    }

    @Bindable
    public void setTitle(String title) {
        this.title = title.trim();
    }

    @Bindable
    public DataType getDataType() {
        return this.dataType;
    }

    @Bindable
    public void setDataType(DataType dataType) {
        List<String> prev = this.getFormatStrings();
        boolean prevDisabled = this.getFormatStringsDisabled();
        this.dataType = dataType;
        this.firePropertyChange("formatStrings", prev, this.getFormatStrings());
        this.firePropertyChange("formatStringsDisabled", prevDisabled, this.getFormatStringsDisabled());
    }

    @Bindable
    public String getAggregateType() {
        return this.aggregateType;
    }

    @Bindable
    public void setAggregateType(String aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Bindable
    public String[] getSamples() {
        return this.samples;
    }

    @Bindable
    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    @Bindable
    public static List<DataType> getAvailableDataTypes() {
        if (availableDataTypes == null || availableDataTypes.size() == 0) {
            DataType[] dt;
            ArrayList<DataType> types = new ArrayList<DataType>();
            block3: for (DataType dataType : dt = DataType.values()) {
                switch (dataType) {
                    case URL: 
                    case BINARY: 
                    case IMAGE: 
                    case UNKNOWN: {
                        continue block3;
                    }
                    default: {
                        types.add(dataType);
                    }
                }
            }
            availableDataTypes = types;
        }
        return availableDataTypes;
    }

    @Bindable
    public boolean getFormatStringsDisabled() {
        return this.dataType != DataType.NUMERIC && this.dataType != DataType.DATE;
    }

    @Bindable
    public List<String> getFormatStrings() {
        ArrayList<String> formatStrings = new ArrayList<String>();
        if (this.dataType == DataType.NUMERIC) {
            formatStrings.add("0.00");
            formatStrings.add("#.#");
            formatStrings.add("#");
            formatStrings.add("#,##0.###");
            formatStrings.add("###,###,###.#");
            formatStrings.add("$#,###");
            formatStrings.add("$#,###.00;($#,###.00)");
        } else if (this.dataType == DataType.DATE) {
            formatStrings.addAll(DATE_FORMATS);
        }
        return formatStrings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregateType == null ? 0 : this.aggregateType.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.fieldType == null ? 0 : this.fieldType.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ignore ? 1231 : 1237);
        result = 31 * result + (this.index ? 1231 : 1237);
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + Arrays.hashCode(this.samples);
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnInfo other = (ColumnInfo)obj;
        if (this.aggregateType == null ? other.aggregateType != null : !this.aggregateType.equals(other.aggregateType)) {
            return false;
        }
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals((Object)other.dataType)) {
            return false;
        }
        if (this.fieldType == null ? other.fieldType != null : !this.fieldType.equals(other.fieldType)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ignore != other.ignore) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        if (!Arrays.equals(this.samples, other.samples)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public int getDateFieldBreakout() {
        return this.dateFieldBreakout;
    }

    public void setDateFieldBreakout(int dateFieldBreakout) {
        this.dateFieldBreakout = dateFieldBreakout;
    }
}

