/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import org.pentaho.metadata.model.Domain;
import org.pentaho.platform.dataaccess.datasource.DatasourceType;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;

public class WizardDatasourceController
extends AbstractXulDialogController<Domain> {
    public static final int DEFAULT_RELATIONAL_TABLE_ROW_COUNT = 5;
    public static final int DEFAULT_CSV_TABLE_ROW_COUNT = 7;
    private DatasourceMessages datasourceMessages;
    private XulDialog datasourceDialog;
    private IXulAsyncDSWDatasourceService service;
    public static final int RELATIONAL_TAB = 0;
    public static final int CSV_TAB = 1;
    private DatasourceModel datasourceModel;
    BindingFactory bf;
    XulTextbox csvDatasourceName = null;
    XulButton okButton = null;
    XulButton cancelButton = null;
    private XulDialog errorDialog;
    private XulDialog successDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    private Domain domainToBeSaved;
    private XulTree modelDataTable = null;
    private XulTree csvDataTable = null;
    private XulDialog clearModelWarningDialog = null;
    private DatasourceType tabValueSelected = null;
    private boolean clearModelWarningShown = false;
    private XulTabbox datasourceTabbox = null;

    @Bindable
    public void init() {
        this.clearModelWarningDialog = (XulDialog)this.document.getElementById("clearModelWarningDialog");
        this.csvDataTable = (XulTree)this.document.getElementById("csvDataTable");
        this.modelDataTable = (XulTree)this.document.getElementById("modelDataTable");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.csvDatasourceName = (XulTextbox)this.document.getElementById("datasourceName");
        this.datasourceDialog = (XulDialog)this.document.getElementById("datasourceDialog");
        this.okButton = (XulButton)this.document.getElementById("datasourceDialog_accept");
        this.cancelButton = (XulButton)this.document.getElementById("datasourceDialog_cancel");
        this.datasourceTabbox = (XulTabbox)this.document.getElementById("datasourceDialogTabbox");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.datasourceModel, "validated", (Object)this.okButton, "!disabled", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        Binding domainBinding = this.bf.createBinding((Object)this.datasourceModel.getGuiStateModel(), "datasourceName", (Object)this.csvDatasourceName, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.datasourceModel, "datasourceName", (Object)this.csvDatasourceName, "value", new BindingConvertor[0]);
        BindingConvertor<DatasourceType, Integer> tabIndexConvertor = new BindingConvertor<DatasourceType, Integer>(){

            public Integer sourceToTarget(DatasourceType value) {
                Integer returnValue = null;
                if (DatasourceType.SQL == value) {
                    returnValue = 0;
                } else if (DatasourceType.CSV == value) {
                    returnValue = 1;
                } else {
                    if (DatasourceType.OLAP == value) {
                        return 2;
                    }
                    if (DatasourceType.NONE == value) {
                        return 0;
                    }
                }
                return returnValue;
            }

            public DatasourceType targetToSource(Integer value) {
                DatasourceType type = null;
                if (value == 0) {
                    type = DatasourceType.SQL;
                } else if (value == 1) {
                    type = DatasourceType.CSV;
                } else if (value == 2) {
                    type = DatasourceType.OLAP;
                }
                return type;
            }
        };
        this.bf.createBinding((Object)this.datasourceModel, "datasourceType", (Object)this.datasourceTabbox, "selectedIndex", new BindingConvertor[]{tabIndexConvertor});
        this.okButton.setDisabled(true);
        this.initialize();
        try {
            domainBinding.fireSourceChanged();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void initialize() {
        this.datasourceModel.clearModel();
    }

    public void showDialog() {
        super.showDialog();
        this.setFocus();
    }

    private void setFocus() {
        this.csvDatasourceName.setFocus();
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    @Bindable
    public void setDatasourceModel(DatasourceModel model) {
        this.datasourceModel = model;
    }

    @Bindable
    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public String getName() {
        return "datasourceController";
    }

    private void showClearModelWarningDialog(DatasourceType value) {
        this.tabValueSelected = value;
        this.clearModelWarningDialog.show();
    }

    @Bindable
    public void closeClearModelWarningDialog() {
        this.clearModelWarningDialog.hide();
        this.clearModelWarningShown = false;
    }

    @Bindable
    public void switchTab() {
        this.closeClearModelWarningDialog();
        if (this.tabValueSelected == DatasourceType.SQL) {
            this.modelDataTable.update();
            this.datasourceModel.setDatasourceType(DatasourceType.SQL);
        } else if (this.tabValueSelected == DatasourceType.CSV) {
            this.csvDataTable.update();
            this.datasourceModel.getGuiStateModel().clearModel();
            this.datasourceModel.setDatasourceType(DatasourceType.CSV);
        }
    }

    @Bindable
    public Boolean beforeTabSwitch(Integer tabIndex) {
        if (0 == tabIndex) {
            if (!this.clearModelWarningShown && this.datasourceModel.getModelInfo() != null) {
                this.showClearModelWarningDialog(DatasourceType.SQL);
                this.clearModelWarningShown = true;
                return false;
            }
            return true;
        }
        if (1 == tabIndex) {
            if (!this.clearModelWarningShown && this.datasourceModel.getQuery() != null && this.datasourceModel.getQuery().length() > 0) {
                this.showClearModelWarningDialog(DatasourceType.CSV);
                this.clearModelWarningShown = true;
                return false;
            }
            return true;
        }
        return true;
    }

    public IXulAsyncDSWDatasourceService getService() {
        return this.service;
    }

    public void setService(IXulAsyncDSWDatasourceService service) {
        this.service = service;
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    protected XulDialog getDialog() {
        return this.datasourceDialog;
    }

    protected Domain getDialogResult() {
        return this.domainToBeSaved;
    }

    @Bindable
    private void saveModelDone() {
        super.onDialogAccept();
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, this.getDatasourceMessages().getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, this.getDatasourceMessages().getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.datasourceMessages = datasourceMessages;
    }

    public DatasourceMessages getDatasourceMessages() {
        return this.datasourceMessages;
    }
}

