/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.Text;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;

public class DatabaseConnectionConverter {
    private static final String USERNAME = "username";
    private static final String ATTRIBUTES = "attributes";
    private static final String DATABASE_TYPE = "databaseType";
    private static final String ACCESS_TYPE = "accessType";
    private static final String PASSWORD = "password";
    private static final String NAME = "name";
    private static final String SERVER_NAME = "serverName";
    private static final String DATA_TABLESPACE = "dataTablespace";
    private static final String INDEX_TABLESPACE = "indexTablespace";
    private static final String HOSTNAME = "hostname";
    private static final String DATABASE_PORT = "databasePort";
    private static final String DATABASE_NAME = "databaseName";
    private static final String DATABASE_CONNECTION = "databaseConnection";
    private DatabaseTypeHelper databaseTypeHelper;

    public DatabaseConnectionConverter(DatabaseTypeHelper databaseTypeHelper) {
        this.databaseTypeHelper = databaseTypeHelper;
    }

    public String convertToXml(IDatabaseConnection dbConn) {
        Document document = XMLParser.createDocument();
        try {
            Element databaseConnection = document.createElement(DATABASE_CONNECTION);
            document.appendChild((Node)databaseConnection);
            Element databaseName = document.createElement(DATABASE_NAME);
            Text databaseNameText = document.createTextNode(dbConn.getDatabaseName());
            databaseName.appendChild((Node)databaseNameText);
            databaseConnection.appendChild((Node)databaseName);
            Element databasePort = document.createElement(DATABASE_PORT);
            Text databasePortText = document.createTextNode(dbConn.getDatabasePort());
            databasePort.appendChild((Node)databasePortText);
            databaseConnection.appendChild((Node)databasePort);
            Element hostname = document.createElement(HOSTNAME);
            Text hostnameText = document.createTextNode(dbConn.getHostname());
            hostname.appendChild((Node)hostnameText);
            databaseConnection.appendChild((Node)hostname);
            Element indexTablespace = document.createElement(INDEX_TABLESPACE);
            Text indexTablespaceText = document.createTextNode(dbConn.getIndexTablespace());
            indexTablespace.appendChild((Node)indexTablespaceText);
            databaseConnection.appendChild((Node)indexTablespace);
            Element dataTablespace = document.createElement(DATA_TABLESPACE);
            Text dataTablespaceText = document.createTextNode(dbConn.getIndexTablespace());
            dataTablespace.appendChild((Node)dataTablespaceText);
            databaseConnection.appendChild((Node)dataTablespace);
            Element informixServername = document.createElement(SERVER_NAME);
            Text informixServernameText = document.createTextNode(dbConn.getInformixServername());
            informixServername.appendChild((Node)informixServernameText);
            databaseConnection.appendChild((Node)informixServername);
            Element name = document.createElement(NAME);
            Text nameText = document.createTextNode(dbConn.getName());
            name.appendChild((Node)nameText);
            databaseConnection.appendChild((Node)name);
            Element username = document.createElement(USERNAME);
            Text usernameTxt = document.createTextNode(dbConn.getUsername());
            username.appendChild((Node)usernameTxt);
            databaseConnection.appendChild((Node)username);
            Element password = document.createElement(PASSWORD);
            Text passwordText = document.createTextNode(dbConn.getPassword());
            password.appendChild((Node)passwordText);
            databaseConnection.appendChild((Node)password);
            Element accessType = document.createElement(ACCESS_TYPE);
            Text accessTypeText = document.createTextNode(dbConn.getAccessType().getName());
            accessType.appendChild((Node)accessTypeText);
            databaseConnection.appendChild((Node)accessType);
            Element databaseType = document.createElement(DATABASE_TYPE);
            Text databaseTypeText = document.createTextNode(dbConn.getDatabaseType().getShortName());
            databaseType.appendChild((Node)databaseTypeText);
            databaseConnection.appendChild((Node)databaseType);
            Element attrributes = document.createElement(ATTRIBUTES);
            databaseConnection.appendChild((Node)attrributes);
            Map attributeMap = dbConn.getAttributes();
            for (String key : attributeMap.keySet()) {
                Element attribute = document.createElement(key);
                Text attributeText = document.createTextNode((String)attributeMap.get(key));
                attribute.appendChild((Node)attributeText);
                attrributes.appendChild((Node)attribute);
            }
            return document.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public IDatabaseConnection convertToObject(String xml) {
        Document document = XMLParser.parse((String)xml);
        Element element = document.getDocumentElement();
        DatabaseConnection databaseConnection = new DatabaseConnection();
        databaseConnection.setDatabaseName(this.getNodeValueByTagName(element, DATABASE_NAME));
        databaseConnection.setHostname(this.getNodeValueByTagName(element, HOSTNAME));
        databaseConnection.setIndexTablespace(this.getNodeValueByTagName(element, INDEX_TABLESPACE));
        databaseConnection.setDataTablespace(this.getNodeValueByTagName(element, DATA_TABLESPACE));
        databaseConnection.setName(this.getNodeValueByTagName(element, NAME));
        databaseConnection.setUsername(this.getNodeValueByTagName(element, USERNAME));
        databaseConnection.setPassword(this.getNodeValueByTagName(element, PASSWORD));
        databaseConnection.setDatabasePort(this.getNodeValueByTagName(element, DATABASE_PORT));
        databaseConnection.setAccessType(DatabaseAccessType.getAccessTypeByName((String)this.getNodeValueByTagName(element, ACCESS_TYPE)));
        databaseConnection.setDatabaseType((IDatabaseType)((DatabaseType)this.databaseTypeHelper.getDatabaseTypeByShortName(this.getNodeValueByTagName(element, DATABASE_TYPE))));
        databaseConnection.setPassword(this.getNodeValueByTagName(element, PASSWORD));
        databaseConnection.setInformixServername(this.getNodeValueByTagName(element, SERVER_NAME));
        for (Node node : this.getNodesByTagName(element, ATTRIBUTES)) {
            databaseConnection.getAttributes().put(node.getNodeName(), node.getNodeValue());
        }
        return databaseConnection;
    }

    private Node getNodeByTagName(Element element, String tagName) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node == null || !node.getNodeName().equals(tagName)) continue;
            return node;
        }
        return null;
    }

    private List<Node> getNodesByTagName(Element element, String tagName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node == null || !node.getNodeName().equals(tagName)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private String getNodeValueByTagName(Element element, String tagName) {
        Node node = this.getNodeByTagName(element, tagName);
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }
}

