/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.service;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.dataaccess.datasource.DatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.service.IUIDatasourceAdminService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceServiceManager;
import org.pentaho.ui.xul.XulServiceCallback;

public class MetadataUIDatasourceService
implements IUIDatasourceAdminService {
    public static final String TYPE = "Metadata";
    private boolean editable = false;
    private boolean removable = true;
    private boolean importable = true;
    private boolean exportable = true;
    private boolean creatable = true;
    private String newUI = "builtin:";
    private String editUI = "builtin:";
    private IXulAsyncDatasourceServiceManager datasourceService;

    public MetadataUIDatasourceService(IXulAsyncDatasourceServiceManager datasourceService) {
        this.datasourceService = datasourceService;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void getIds(final XulServiceCallback<List<IDatasourceInfo>> callback) {
        this.datasourceService.getMetadataDatasourceIds(new XulServiceCallback<List<String>>(){

            public void success(List<String> ids) {
                ArrayList<DatasourceInfo> datasourceInfos = new ArrayList<DatasourceInfo>();
                for (String id : ids) {
                    if (id == null || id.length() <= 0) continue;
                    datasourceInfos.add(new DatasourceInfo(id, id, MetadataUIDatasourceService.TYPE, MetadataUIDatasourceService.this.editable, MetadataUIDatasourceService.this.removable, MetadataUIDatasourceService.this.importable, MetadataUIDatasourceService.this.exportable));
                }
                callback.success(datasourceInfos);
            }

            public void error(String message, Throwable error) {
                callback.error(message, error);
            }
        });
    }

    @Override
    public String getNewUI() {
        return this.newUI;
    }

    @Override
    public String getEditUI(IDatasourceInfo dsInfo) {
        return this.editUI;
    }

    @Override
    public void export(IDatasourceInfo dsInfo) {
        this.datasourceService.export(dsInfo);
    }

    @Override
    public void remove(IDatasourceInfo dsInfo, Object callback) {
        this.datasourceService.remove(dsInfo, callback);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    @Override
    public boolean isImportable() {
        return this.importable;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }
}

