/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.service;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.platform.dataaccess.datasource.DatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.service.IUIDatasourceAdminService;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.event.IDatabaseConnectionList;
import org.pentaho.ui.xul.XulServiceCallback;

public class JdbcDatasourceService
implements IUIDatasourceAdminService {
    public static final String TYPE = "JDBC";
    private boolean editable = true;
    private boolean removable = true;
    private boolean importable = true;
    private boolean exportable = true;
    private boolean creatable = true;
    private String newUI = "builtin:";
    private String editUI = "builtin:";
    public static final String ATTRIBUTE_STANDARD_CONNECTION = "STANDARD_CONNECTION";
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);

    @Override
    public String getType() {
        return TYPE;
    }

    public static String getBaseURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/connection/";
        }
        return moduleUrl + "plugin/data-access/api/connection/";
    }

    public static String getMetadataBaseURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/metadataDA/";
        }
        return moduleUrl + "plugin/data-access/api/metadataDA/";
    }

    @Override
    public void getIds(final XulServiceCallback<List<IDatasourceInfo>> callback) {
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, JdbcDatasourceService.getMetadataBaseURL() + "getDatasourcePermissions");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
            requestBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    callback.error(exception.getMessage(), exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    if (response.getText().equals("EDIT")) {
                        String cacheBuster = "?ts=" + new Date().getTime();
                        RequestBuilder listConnectionBuilder = new RequestBuilder(RequestBuilder.GET, JdbcDatasourceService.getBaseURL() + "list" + cacheBuster);
                        listConnectionBuilder.setHeader("Content-Type", "application/json");
                        try {
                            listConnectionBuilder.sendRequest(null, new RequestCallback(){

                                public void onError(Request request, Throwable exception) {
                                    callback.error(exception.getMessage(), exception);
                                }

                                public void onResponseReceived(Request request, Response response) {
                                    AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)JdbcDatasourceService.this.connectionAutoBeanFactory, IDatabaseConnectionList.class, (String)response.getText());
                                    List connections = ((IDatabaseConnectionList)bean.as()).getDatabaseConnections();
                                    ArrayList<DatasourceInfo> datasourceInfos = new ArrayList<DatasourceInfo>();
                                    for (IDatabaseConnection connection : connections) {
                                        Map attributes = connection.getAttributes();
                                        if (attributes.containsKey(JdbcDatasourceService.ATTRIBUTE_STANDARD_CONNECTION) && ((String)attributes.get(JdbcDatasourceService.ATTRIBUTE_STANDARD_CONNECTION)).equals(Boolean.FALSE.toString())) continue;
                                        datasourceInfos.add(new DatasourceInfo(connection.getName(), connection.getName(), JdbcDatasourceService.TYPE, JdbcDatasourceService.this.editable, JdbcDatasourceService.this.removable, JdbcDatasourceService.this.importable, JdbcDatasourceService.this.exportable));
                                    }
                                    callback.success(datasourceInfos);
                                }
                            });
                        }
                        catch (RequestException e) {
                            callback.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (RequestException e) {
            callback.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getNewUI() {
        return this.newUI;
    }

    @Override
    public String getEditUI(IDatasourceInfo dsInfo) {
        return this.editUI;
    }

    @Override
    public void export(IDatasourceInfo dsInfo) {
    }

    @Override
    public void remove(IDatasourceInfo dsInfo, Object callback) {
        final XulServiceCallback responseCallback = (XulServiceCallback)callback;
        RequestBuilder deleteConnectionBuilder = new RequestBuilder(RequestBuilder.DELETE, JdbcDatasourceService.getBaseURL() + NameUtils.URLEncode((String)"deletebyname?name={0}", (String)dsInfo.getName()));
        try {
            deleteConnectionBuilder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    responseCallback.success((Object)(response.getStatusCode() == 200 ? 1 : 0));
                }

                public void onError(Request request, Throwable error) {
                    responseCallback.error(error.getLocalizedMessage(), error);
                }
            });
        }
        catch (RequestException e) {
            responseCallback.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    @Override
    public boolean isImportable() {
        return this.importable;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }
}

