/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.importing;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.dataaccess.datasource.ui.importing.ParameterDialogModel;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class AnalysisImportDialogModel
extends XulEventSourceAdapter {
    private List<IDatabaseConnection> connectionList = new ArrayList<IDatabaseConnection>();
    private List<ParameterDialogModel> analysisParameters = new ArrayList<ParameterDialogModel>();
    private String uploadedFile;
    private IDatabaseConnection connection;
    private boolean isParameterMode;
    private ParameterDialogModel selectedAnalysisParameter;

    public void addParameter(String name, String value) {
        if (this.selectedAnalysisParameter == null) {
            if (!this.containsParameter(name)) {
                this.analysisParameters.add(new ParameterDialogModel(name, value));
            }
        } else {
            this.selectedAnalysisParameter.setName(name);
            this.selectedAnalysisParameter.setValue(value);
        }
        this.firePropertyChange("analysisParameters", null, this.analysisParameters);
    }

    public void removeParameter(int paramIndex) {
        this.selectedAnalysisParameter = null;
        this.analysisParameters.remove(paramIndex);
        this.firePropertyChange("analysisParameters", null, this.analysisParameters);
    }

    public void removeAllParameters() {
        this.analysisParameters.clear();
        this.firePropertyChange("analysisParameters", null, this.analysisParameters);
    }

    public String getUploadedFile() {
        return this.uploadedFile;
    }

    public void setUploadedFile(String uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    @Bindable
    public List<ParameterDialogModel> getAnalysisParameters() {
        return this.analysisParameters;
    }

    @Bindable
    public void setAnalysisParameters(List<ParameterDialogModel> value) {
        List<ParameterDialogModel> previousValue = this.analysisParameters;
        this.analysisParameters = value;
        this.firePropertyChange("analysisParameters", previousValue, value);
    }

    @Bindable
    public List<IDatabaseConnection> getConnectionList() {
        return this.connectionList;
    }

    @Bindable
    public void setConnectionList(List<IDatabaseConnection> value) {
        List<IDatabaseConnection> previousValue = this.connectionList;
        this.connectionList = value;
        this.firePropertyChange("connectionList", previousValue, value);
    }

    @Bindable
    public IDatabaseConnection getConnection() {
        return this.connection;
    }

    @Bindable
    public void setConnection(IDatabaseConnection value) {
        IDatabaseConnection previousValue = this.connection;
        this.connection = value;
        this.firePropertyChange("connection", previousValue, value);
    }

    public String getParameters() {
        String result = "";
        if (this.isParameterMode) {
            String sep = ";";
            String eq = "=";
            String quot = "\"";
            for (ParameterDialogModel currentParameter : this.analysisParameters) {
                String value;
                if (!result.isEmpty()) {
                    result = result + sep;
                }
                if (!((value = currentParameter.getValue()).startsWith(quot) && value.endsWith(quot) || !value.contains(sep))) {
                    value = quot + value + quot;
                }
                result = result + currentParameter.getName() + eq + value;
            }
        }
        return result;
    }

    private boolean containsParameter(String name) {
        boolean containsParameter = false;
        for (ParameterDialogModel parameter : this.analysisParameters) {
            if (!parameter.getName().equalsIgnoreCase(name)) continue;
            containsParameter = true;
            break;
        }
        return containsParameter;
    }

    public void setParameterMode(boolean value) {
        this.isParameterMode = value;
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.isParameterMode) {
            isValid = this.analysisParameters.size() > 0;
        }
        return isValid && this.uploadedFile != null && this.connection != null;
    }

    public void setSelectedAnalysisParameter(int index) {
        this.selectedAnalysisParameter = index > -1 ? this.analysisParameters.get(index) : null;
    }

    public ParameterDialogModel getSelectedAnalysisParameter() {
        return this.selectedAnalysisParameter;
    }
}

