/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.MetadataService;
import org.pentaho.platform.dataaccess.datasource.api.resources.ResourceUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.JaxbList;

public class MetadataResource {
    private static final Log logger = LogFactory.getLog(MetadataResource.class);
    protected static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String SUCCESS = "3";
    protected MetadataService service = new MetadataService();
    protected IMetadataDomainRepository metadataDomainRepository;
    protected ResourceUtil resourceUtil = new ResourceUtil();

    public MetadataResource() {
        this.metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
    }

    @GET
    @Path(value="/domain/{domainId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export Metadata datasource."), @ResponseCode(code=500, condition="Failure to export Metadata datasource.")})
    public Response downloadMetadata(@PathParam(value="domainId") String domainId) {
        if (!this.canAdminister()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!this.isInstanceOfIPentahoMetadataDomainRepositoryExporter(this.metadataDomainRepository)) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        Map<String, InputStream> fileData = this.getDomainFilesData(domainId);
        return this.createAttachment(fileData, domainId);
    }

    @DELETE
    @Path(value="/domain/{domainId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource removed."), @ResponseCode(code=401, condition="User is not authorized to delete the Metadata datasource.")})
    public Response deleteMetadata(@PathParam(value="domainId") String domainId) {
        try {
            this.service.removeMetadata(domainId);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/domain")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of existing metadata IDs")})
    public JaxbList<String> listDomains() {
        return this.createNewJaxbList(this.service.getMetadataDatasourceIds());
    }

    public Response importMetadataDatasourceLegacy(@PathParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) {
        try {
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            this.service.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overWriteInRepository, localeFiles, localeFilesInfo);
            return Response.ok().status(new Integer(SUCCESS).intValue()).type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return this.buildServerErrorResponse(e);
        }
        catch (PlatformImportException e) {
            if (e.getErrorStatus() == 10) {
                FileResource fr = this.createFileResource();
                return this.buildServerError003Response(domainId, fr);
            }
            String msg = e.getMessage();
            logger.error((Object)("Error import metadata: " + msg + " status = " + e.getErrorStatus()));
            Throwable throwable = e.getCause();
            if (throwable != null) {
                msg = throwable.getMessage();
                logger.error((Object)("Root cause: " + msg));
            }
            return this.buildOkResponse(String.valueOf(e.getErrorStatus()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerError001Response();
        }
    }

    @PUT
    @Path(value="/domain/{domainId : .+}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=409, condition="Content already exists (use overwrite flag to force)"), @ResponseCode(code=401, condition="Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Unspecified general error has occurred"), @ResponseCode(code=412, condition="Metadata datasource import failed.  Error code or message included in response entity"), @ResponseCode(code=403, condition="Access Control Forbidden"), @ResponseCode(code=201, condition="Indicates successful import")})
    public Response importMetadata(@PathParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") Boolean overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) {
        try {
            this.service.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (PlatformImportException e) {
            int status;
            if (e.getErrorStatus() == 10) {
                throw new ResourceUtil.PublishProhibitedException(e.getMessage());
            }
            String msg = e.getMessage();
            logger.error((Object)("Error import metadata: " + msg + " status = " + e.getErrorStatus()));
            Throwable throwable = e.getCause();
            if (throwable != null) {
                msg = throwable.getMessage();
                logger.error((Object)("Root cause: " + msg));
            }
            if ((status = e.getErrorStatus()) == 8) {
                throw new ResourceUtil.ContentAlreadyExistsException(msg);
            }
            throw new ResourceUtil.ImportFailedException(msg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ResourceUtil.UnspecifiedErrorException(e.getMessage());
        }
    }

    protected Response importMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo) {
        try {
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            this.service.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overWriteInRepository, localeFiles, localeFilesInfo);
            return Response.ok().status(new Integer(SUCCESS).intValue()).type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return this.buildServerErrorResponse(e);
        }
        catch (PlatformImportException e) {
            if (e.getErrorStatus() == 10) {
                FileResource fr = this.createFileResource();
                return this.buildServerError003Response(domainId, fr);
            }
            String msg = e.getMessage();
            logger.error((Object)("Error import metadata: " + msg + " status = " + e.getErrorStatus()));
            Throwable throwable = e.getCause();
            if (throwable != null) {
                msg = throwable.getMessage();
                logger.error((Object)("Root cause: " + msg));
            }
            return this.buildOkResponse(String.valueOf(e.getErrorStatus()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerError001Response();
        }
    }

    protected Response buildOkResponse(String statusCode) {
        return Response.ok((Object)statusCode).type("text/plain").build();
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response buildServerErrorResponse(PentahoAccessControlException e) {
        return Response.serverError().entity((Object)e.toString()).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected Response buildServerError001Response() {
        return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
    }

    protected Response buildServerError003Response(String domainId, FileResource fr) {
        return Response.status((int)10).entity((Object)Messages.getString("MetadataDatasourceService.ERROR_003_PROHIBITED_SYMBOLS_ERROR", domainId, (String)fr.doGetReservedCharactersDisplay().getEntity())).build();
    }

    protected boolean canAdminister() {
        return DatasourceService.canAdminister();
    }

    protected Response createAttachment(Map<String, InputStream> fileData, String dswId) {
        return this.resourceUtil.createAttachment(fileData, dswId);
    }

    protected JaxbList<String> createNewJaxbList(List<String> DSWDatasources) {
        return new JaxbList(DSWDatasources);
    }

    protected Map<String, InputStream> getDomainFilesData(String domainId) {
        return ((IPentahoMetadataDomainRepositoryExporter)this.metadataDomainRepository).getDomainFilesData(domainId);
    }

    protected boolean isInstanceOfIPentahoMetadataDomainRepositoryExporter(IMetadataDomainRepository obj) {
        return obj instanceof IPentahoMetadataDomainRepositoryExporter;
    }

    protected FileResource createFileResource() {
        return new FileResource();
    }
}

