/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.web.http.api.resources.JaxbList;

public class JDBCDatasourceResource {
    protected ConnectionServiceImpl service = new ConnectionServiceImpl();
    private static final Log logger = LogFactory.getLog(JDBCDatasourceResource.class);

    @DELETE
    @Path(value="/connection/{name : .+}")
    @StatusCodes(value={@ResponseCode(code=200, condition="JDBC datasource removed successfully."), @ResponseCode(code=304, condition="User is not authorized to remove the JDBC datasource or the connection does not exist."), @ResponseCode(code=500, condition="An unexected error occurred while deleting the JDBC datasource.")})
    public Response deleteConnection(@PathParam(value="name") String name) {
        try {
            boolean success = this.service.deleteConnection(name);
            if (success) {
                return this.buildOkResponse();
            }
            return this.buildNotModifiedResponse();
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse();
        }
    }

    @GET
    @Path(value="/connection")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of JDBC datasource IDs"), @ResponseCode(code=500, condition="Internal error retrieving JDBC datasource IDs")})
    public JaxbList<String> getConnectionIDs() {
        ArrayList<String> connStrList = new ArrayList<String>();
        try {
            List<IDatabaseConnection> conns = this.service.getConnections();
            for (IDatabaseConnection conn : conns) {
                conn.setPassword(null);
                connStrList.add(conn.getName());
            }
        }
        catch (ConnectionServiceException e) {
            logger.error((Object)("Error " + e.getMessage()));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        JaxbList connections = new JaxbList(connStrList);
        return connections;
    }

    @GET
    @Path(value="/connection/{name : .+}")
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the JDBC datasource"), @ResponseCode(code=500, condition="An error occurred retrieving the JDBC datasource")})
    public Response getConnection(@PathParam(value="name") String name) {
        try {
            return this.buildOkResponse(this.service.getConnectionByName(name));
        }
        catch (ConnectionServiceException e) {
            logger.error((Object)("Error " + e.getMessage()));
            return this.buildServerErrorResponse();
        }
    }

    @PUT
    @Path(value="/connection/{connectionId : .+}")
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="JDBC datasource added successfully."), @ResponseCode(code=403, condition="User is not authorized to add JDBC datasources."), @ResponseCode(code=304, condition="Datasource was not modified"), @ResponseCode(code=500, condition="An unexected error occurred while adding the JDBC datasource.")})
    public Response addOrUpdate(@PathParam(value="connectionId") String connectionName, DatabaseConnection connection) {
        try {
            this.validateAccess();
            connection.setId(connectionName);
            IDatabaseConnection savedConn = null;
            try {
                savedConn = this.service.getConnectionByName(connectionName);
            }
            catch (ConnectionServiceException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            boolean success = false;
            if (savedConn != null) {
                if (StringUtils.isBlank((String)connection.getPassword())) {
                    connection.setPassword(savedConn.getPassword());
                }
                connection.setId(savedConn.getId());
                success = this.service.updateConnection((IDatabaseConnection)connection);
            } else {
                success = this.service.addConnection((IDatabaseConnection)connection);
            }
            if (success) {
                return this.buildOkResponse();
            }
            return this.buildNotModifiedResponse();
        }
        catch (PentahoAccessControlException t) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (Throwable t) {
            logger.error((Object)("Error " + t.getMessage()));
            return this.buildServerErrorResponse();
        }
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildOkResponse(IDatabaseConnection connection) {
        return Response.ok((Object)connection).build();
    }

    protected Response buildNotModifiedResponse() {
        return Response.notModified().build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected void validateAccess() throws PentahoAccessControlException {
        DatasourceService.validateAccess();
    }
}

