/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;

public class DatasourceService {
    protected IMetadataDomainRepository metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
    protected IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());

    public static boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }

    public static void validateAccess() throws PentahoAccessControlException {
        boolean isAdmin;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean bl = isAdmin = policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && (policy.isAllowed("org.pentaho.security.administerSecurity") || policy.isAllowed("org.pentaho.security.publish"));
        if (!isAdmin) {
            throw new PentahoAccessControlException("Access Denied");
        }
    }

    protected String fixEncodedSlashParam(String param) {
        return param.replaceAll("\\\\", "%5C").replaceAll("/", "%2F");
    }

    protected boolean isMetadataDatasource(String id) {
        Domain domain;
        try {
            domain = this.metadataDomainRepository.getDomain(id);
            if (domain == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        List logicalModelList = domain.getLogicalModels();
        if (logicalModelList != null && logicalModelList.size() >= 1) {
            for (LogicalModel logicalModel : logicalModelList) {
                Object property = logicalModel.getProperty("AGILE_BI_GENERATED_SCHEMA");
                if (property != null) {
                    return false;
                }
                property = logicalModel.getProperty("WIZARD_GENERATED_SCHEMA");
                if (property == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static void parseMondrianSchemaName(String dswId, Map<String, InputStream> fileData) {
        String keySchema = "schema.xml";
        if (fileData.containsKey("schema.xml")) {
            int xmiIndex = dswId.lastIndexOf(".xmi");
            fileData.put((xmiIndex > 0 ? dswId.substring(0, xmiIndex) : dswId) + ".mondrian.xml", fileData.get("schema.xml"));
            fileData.remove("schema.xml");
        }
    }
}

