/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mondrian.olap.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnalysisService
extends DatasourceService {
    public static final String METADATA_EXT = ".xmi";
    private static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String DATASOURCE_NAME = "datasourceName";
    private static final String ENABLE_XMLA = "EnableXmla";
    private static final String PARAMETERS = "parameters";
    private static final String DOMAIN_ID = "domain-id";
    private static final String MONDRIAN_MIME_TYPE = "application/vnd.pentaho.mondrian+xml";
    private static final String CATALOG_NAME = "catalogName";
    private static final String UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getLog(AnalysisService.class);
    private static IPlatformImporter importer;

    public AnalysisService() {
        importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
    }

    public Map<String, InputStream> doGetAnalysisFilesAsDownload(String analysisId) throws PentahoAccessControlException {
        if (!this.canAdministerCheck()) {
            throw new PentahoAccessControlException();
        }
        MondrianCatalogRepositoryHelper helper = this.createNewMondrianCatalogRepositoryHelper();
        Map fileData = helper.getModrianSchemaFiles(analysisId);
        return fileData;
    }

    public void removeAnalysis(String analysisId) throws PentahoAccessControlException {
        if (!this.canAdministerCheck()) {
            throw new PentahoAccessControlException();
        }
        this.mondrianCatalogService.removeCatalog(this.fixEncodedSlashParam(analysisId), this.getSession());
    }

    public List<String> getAnalysisDatasourceIds() {
        ArrayList<String> analysisIds = new ArrayList<String>();
        List mockMondrianCatalogList = this.mondrianCatalogService.listCatalogs(this.getSession(), false);
        for (MondrianCatalog mondrianCatalog : mockMondrianCatalogList) {
            String domainId = mondrianCatalog.getName() + METADATA_EXT;
            Set ids = this.metadataDomainRepository.getDomainIds();
            if (ids.contains(domainId)) continue;
            analysisIds.add(mondrianCatalog.getName());
        }
        return analysisIds;
    }

    public void putMondrianSchema(InputStream dataInputStream, FormDataContentDisposition schemaFileInfo, String catalogName, String origCatalogName, String datasourceName, boolean overwrite, boolean xmlaEnabledFlag, String parameters) throws PentahoAccessControlException, PlatformImportException, Exception {
        this.accessValidation();
        String fileName = schemaFileInfo.getFileName();
        this.processMondrianImport(dataInputStream, catalogName, origCatalogName, overwrite, xmlaEnabledFlag, parameters, fileName);
    }

    protected void processMondrianImport(InputStream dataInputStream, String catalogName, String origCatalogName, boolean overwrite, boolean xmlaEnabledFlag, String parameters, String fileName) throws PlatformImportException {
        boolean overWriteInRepository = this.determineOverwriteFlag(parameters, overwrite);
        IPlatformImportBundle bundle = this.createPlatformBundle(parameters, dataInputStream, catalogName, overWriteInRepository, fileName, xmlaEnabledFlag);
        if (!StringUtils.isEmpty((String)origCatalogName) && !bundle.getName().equals(origCatalogName)) {
            IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            catalogService.removeCatalog(origCatalogName, PentahoSessionHolder.getSession());
        }
        importer.importFile(bundle);
    }

    private boolean determineOverwriteFlag(String parameters, boolean overWriteInRepository) {
        String overwriteStr = this.getValue(parameters, OVERWRITE_IN_REPOS);
        if (overwriteStr != null) {
            overWriteInRepository = "True".equalsIgnoreCase(overwriteStr);
        }
        return overWriteInRepository;
    }

    private IPlatformImportBundle createPlatformBundle(String parameters, InputStream dataInputStream, String catalogName, boolean overWriteInRepository, String fileName, boolean xmlaEnabled) {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)dataInputStream);
            if (bytes.length == 0 && catalogName != null) {
                MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
                Map fileData = helper.getModrianSchemaFiles(catalogName);
                dataInputStream = (InputStream)fileData.get("schema.xml");
                bytes = IOUtils.toByteArray((InputStream)dataInputStream);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        String datasource = this.getValue(parameters, "Datasource");
        String domainId = this.determineDomainCatalogName(parameters, catalogName, fileName, new ByteArrayInputStream(bytes));
        String sep = ";";
        if (StringUtils.isEmpty((String)parameters)) {
            parameters = "Provider=mondrian";
            parameters = parameters + sep + DATASOURCE_NAME + "=" + datasource;
            parameters = parameters + sep + ENABLE_XMLA + "=" + xmlaEnabled;
        }
        RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().input((InputStream)new ByteArrayInputStream(bytes)).charSet(UTF_8).hidden(false).name(domainId).overwriteFile(overWriteInRepository).mime(MONDRIAN_MIME_TYPE).withParam(PARAMETERS, parameters).withParam(DOMAIN_ID, domainId);
        bundleBuilder.withParam(ENABLE_XMLA, Boolean.toString(xmlaEnabled));
        RepositoryFileImportBundle bundle = bundleBuilder.build();
        return bundle;
    }

    private String getValue(String parameters, String key) {
        Util.PropertyList propertyList = Util.parseConnectString((String)parameters);
        return propertyList.get(key);
    }

    private String determineDomainCatalogName(String parameters, String catalogName, String fileName, InputStream inputStream) {
        String domainId = null;
        try {
            Node name;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList schemas = document.getElementsByTagName("Schema");
            Node schema = schemas.item(0);
            if (schema != null && (domainId = (name = schema.getAttributes().getNamedItem("name")).getTextContent()) != null && !"".equals(domainId)) {
                return domainId;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        String string = domainId = this.getValue(parameters, CATALOG_NAME) == null ? catalogName : this.getValue(parameters, CATALOG_NAME);
        if (domainId == null || "".equals(domainId)) {
            domainId = fileName.contains(".") ? fileName.substring(0, fileName.indexOf(".")) : fileName;
        } else if (domainId.contains(".")) {
            domainId = domainId.substring(0, domainId.indexOf("."));
        }
        return domainId;
    }

    protected MondrianCatalogRepositoryHelper createNewMondrianCatalogRepositoryHelper() {
        return new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    protected boolean canAdministerCheck() {
        return DatasourceService.canAdminister();
    }

    protected void accessValidation() throws PentahoAccessControlException {
        DatasourceService.validateAccess();
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }
}

