/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource;

import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.GwtDatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DatasourceInfo
extends XulEventSourceAdapter
implements IDatasourceInfo {
    private static final long serialVersionUID = 1L;
    private static final String MSG_PREFIX = "DatasourceInfo.DisplayType.";
    String name;
    String id;
    String type;
    String displayType;
    boolean editable;
    boolean removable;
    boolean importable;
    boolean exportable;
    boolean creatable;
    static transient DatasourceMessages messageBundle;

    public DatasourceInfo() {
    }

    public DatasourceInfo(String name, String id, String type) {
        this.name = name;
        this.id = id;
        this.type = type;
    }

    public DatasourceInfo(String name, String id, String type, boolean editable, boolean removable, boolean importable, boolean exportable) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.editable = editable;
        this.removable = removable;
        this.importable = importable;
        this.exportable = exportable;
        this.creatable = true;
    }

    public DatasourceInfo(String name, String id, String type, boolean editable, boolean removable, boolean importable, boolean exportable, boolean creatable) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.editable = editable;
        this.removable = removable;
        this.importable = importable;
        this.exportable = exportable;
        this.creatable = creatable;
    }

    @Override
    @Bindable
    public String getName() {
        return this.name;
    }

    @Override
    @Bindable
    public String getDisplayType() {
        if (this.displayType != null) {
            return this.displayType;
        }
        return DatasourceInfo.getDisplayType(this.getType());
    }

    public static String getDisplayType(String type) {
        if (type == null) {
            throw new IllegalArgumentException(DatasourceInfo.getString("DatasourceInfo.TYPE_NULL"));
        }
        String displayName = null;
        try {
            String key = MSG_PREFIX + type.replace(" ", "_");
            displayName = DatasourceInfo.getString(key);
            return displayName == null || displayName.equals(key) ? type : displayName;
        }
        catch (Exception e) {
            return type;
        }
    }

    public static String getDisplayType(String type, GwtDatasourceMessages messages) {
        if (type == null) {
            throw new IllegalArgumentException(DatasourceInfo.getString("DatasourceInfo.TYPE_NULL"));
        }
        String displayName = null;
        try {
            String key = MSG_PREFIX + type.replace(" ", "_");
            displayName = DatasourceInfo.getString(key);
            return displayName == null || displayName.equals(key) ? type : displayName;
        }
        catch (Exception e) {
            return type;
        }
    }

    @Override
    @Bindable
    public String getId() {
        return this.id;
    }

    @Override
    @Bindable
    public String getType() {
        return this.type;
    }

    public String toString() {
        return "DatasourceInfo [id=" + this.id + ", type=" + this.type + "]";
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    @Override
    public boolean isImportable() {
        return this.importable;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }

    public static void setMessageBundle(DatasourceMessages bundle) {
        messageBundle = bundle;
    }

    protected static String getString(String key) {
        if (messageBundle != null) {
            return messageBundle.getString(key);
        }
        return MessageHandler.getString(key);
    }
}

