/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.pig.PigStreamingBase;
import org.apache.pig.StreamToPig;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public abstract class OutputHandler {
    public static final Object END_OF_OUTPUT = new Object();
    private static final byte[] DEFAULT_RECORD_DELIM = new byte[]{10};
    protected StreamToPig deserializer;
    private PigStreamingBase newDeserializer;
    protected LineReader in = null;
    private Text currValue = new Text();
    private BufferedPositionedInputStream istream;
    private String recordDelimStr = null;
    private int recordDelimLength = 0;
    protected boolean alreadyClosed = false;

    public abstract OutputType getOutputType();

    public void bindTo(String fileName, BufferedPositionedInputStream is, long offset, long end) throws IOException {
        this.istream = is;
        this.in = new LineReader((InputStream)this.istream);
        if (this.deserializer instanceof PigStreamingBase) {
            this.newDeserializer = (PigStreamingBase)this.deserializer;
        }
    }

    public Tuple getNext() throws IOException {
        if (this.in == null) {
            return null;
        }
        this.currValue.clear();
        if (!this.readValue()) {
            return null;
        }
        if (this.newDeserializer != null) {
            return this.newDeserializer.deserialize(this.currValue.getBytes(), 0, this.currValue.getLength());
        }
        byte[] newBytes = new byte[this.currValue.getLength()];
        System.arraycopy(this.currValue.getBytes(), 0, newBytes, 0, this.currValue.getLength());
        return this.deserializer.deserialize(newBytes);
    }

    private boolean readValue() throws IOException {
        int num = this.in.readLine(this.currValue);
        if (num <= 0) {
            return false;
        }
        while (!this.isEndOfRow()) {
            this.currValue.append(new byte[]{10}, 0, 1);
            byte[] lineBytes = this.readNextLine();
            if (lineBytes == null) break;
            this.currValue.append(lineBytes, 0, lineBytes.length);
        }
        return true;
    }

    private byte[] readNextLine() throws IOException {
        Text line = new Text();
        int num = this.in.readLine(line);
        byte[] lineBytes = line.getBytes();
        if (num <= 0) {
            return null;
        }
        return lineBytes;
    }

    private boolean isEndOfRow() {
        if (this.recordDelimStr == null) {
            byte[] recordDelimBa = this.getRecordDelimiter();
            this.recordDelimLength = recordDelimBa.length - 1;
            this.recordDelimStr = new String(recordDelimBa, 0, this.recordDelimLength, Charsets.UTF_8);
        }
        if (this.recordDelimLength == 0 || this.currValue.getLength() < this.recordDelimLength) {
            return true;
        }
        return this.currValue.find(this.recordDelimStr, this.currValue.getLength() - this.recordDelimLength) >= 0;
    }

    protected byte[] getRecordDelimiter() {
        return DEFAULT_RECORD_DELIM;
    }

    public synchronized void close() throws IOException {
        if (!this.alreadyClosed) {
            this.istream.close();
            this.istream = null;
            this.alreadyClosed = true;
        }
    }

    public static enum OutputType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

