/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelOperationReq;
import org.apache.hive.service.cli.thrift.TCancelOperationResp;
import org.apache.hive.service.cli.thrift.TCloseOperationReq;
import org.apache.hive.service.cli.thrift.TCloseOperationResp;
import org.apache.hive.service.cli.thrift.TExecuteStatementReq;
import org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import org.apache.hive.service.cli.thrift.TGetLogReq;
import org.apache.hive.service.cli.thrift.TGetLogResp;
import org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.hive.service.cli.thrift.TStatusCode;

public class HiveStatement
implements Statement {
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle;
    private final TSessionHandle sessHandle;
    private final Map<String, String> sessConf = new HashMap<String, String>();
    private int fetchSize = 50;
    private boolean isScrollableResultset = false;
    private final HiveConnection hiveConn;
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;

    public HiveStatement(TCLIService.Iface client, TSessionHandle sessHandle, HiveConnection hiveConn) {
        this(client, sessHandle, hiveConn, false);
    }

    public HiveStatement(TCLIService.Iface client, TSessionHandle sessHandle, HiveConnection hiveConn, boolean isScrollableResultset) {
        this.client = client;
        this.sessHandle = sessHandle;
        this.isScrollableResultset = isScrollableResultset;
        this.hiveConn = hiveConn;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't cancel after statement has been closed", "24000");
        }
        TCancelOperationReq cancelReq = new TCancelOperationReq();
        cancelReq.setOperationHandle(this.stmtHandle);
        try {
            TCancelOperationResp cancelResp = this.client.CancelOperation(cancelReq);
            Utils.verifySuccessWithInfo(cancelResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), "08S01", e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    private void closeClientOperation() throws SQLException {
        try {
            this.clearWarnings();
            if (this.stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq();
                closeReq.setOperationHandle(this.stmtHandle);
                TCloseOperationResp tCloseOperationResp = this.client.CloseOperation(closeReq);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), "08S01", e);
        }
        this.stmtHandle = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        this.resultSet = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't execute after statement has been closed");
        }
        try {
            this.closeClientOperation();
            TExecuteStatementReq execReq = new TExecuteStatementReq(this.sessHandle, sql);
            execReq.setConfOverlay(this.sessConf);
            TExecuteStatementResp execResp = this.client.ExecuteStatement(execReq);
            if (execResp.getStatus().getStatusCode().equals((Object)TStatusCode.STILL_EXECUTING_STATUS)) {
                this.warningChain = Utils.addWarning(this.warningChain, new SQLWarning("Query execuing asynchronously"));
            } else {
                this.hiveConn.loadExtendedErrorMsg(execResp.getOperationHandle(), execResp.getStatus());
                Utils.verifySuccessWithInfo(execResp.getStatus());
            }
            this.stmtHandle = execResp.getOperationHandle();
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString(), "08S01", ex);
        }
        if (!this.stmtHandle.isHasResultSet()) {
            TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
            boolean requestComplete = false;
            while (!requestComplete) {
                try {
                    TGetOperationStatusResp statusResp = this.client.GetOperationStatus(statusReq);
                    Utils.verifySuccessWithInfo(statusResp.getStatus());
                    if (statusResp.isSetOperationState()) {
                        switch (statusResp.getOperationState()) {
                            case CLOSED_STATE: 
                            case FINISHED_STATE: {
                                return false;
                            }
                            case CANCELED_STATE: {
                                throw new SQLException("Query was cancelled", "01000");
                            }
                            case ERROR_STATE: {
                                throw new SQLException("Query failed", "HY000");
                            }
                            case UKNOWN_STATE: {
                                throw new SQLException("Unknown query", "HY000");
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    throw new SQLException(ex.toString(), "08S01", ex);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            return false;
        }
        this.resultSet = new HiveQueryResultSet.Builder().setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).setHiveConn(this.hiveConn).setNeedExtendedDiagnostics(true).build();
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public String getLog() throws SQLException {
        TGetLogResp getLogResp;
        if (this.isClosed) {
            throw new SQLException("Can't get log for statement after statement has been closed");
        }
        TGetLogReq getLogReq = new TGetLogReq();
        getLogReq.setOperationHandle(this.stmtHandle);
        try {
            getLogResp = this.client.GetLog(getLogReq);
            Utils.verifySuccessWithInfo(getLogResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), "08S01", e);
        }
        return getLogResp.getLog();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

