/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.thrift.EmbeddedThriftCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TGetInfoReq;
import org.apache.hive.service.cli.thrift.TGetInfoResp;
import org.apache.hive.service.cli.thrift.TGetInfoType;
import org.apache.hive.service.cli.thrift.TGetLogReq;
import org.apache.hive.service.cli.thrift.TGetLogResp;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.cli.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.hive.service.cli.thrift.TStatus;
import org.apache.hive.service.cli.thrift.TStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveConnection
implements Connection {
    private static final String HIVE_AUTH_TYPE = "auth";
    private static final String HIVE_AUTH_QOP = "sasl.qop";
    private static final String HIVE_AUTH_SIMPLE = "noSasl";
    private static final String HIVE_AUTH_TOKEN = "delegationToken";
    private static final String HIVE_AUTH_USER = "user";
    private static final String HIVE_AUTH_PRINCIPAL = "principal";
    private static final String HIVE_AUTH_PASSWD = "password";
    private static final String HIVE_ANONYMOUS_USER = "anonymous";
    private static final String HIVE_ANONYMOUS_PASSWD = "anonymous";
    private static final String HIVE_USE_SSL = "ssl";
    private static final String HIVE_SSL_TRUST_STORE = "sslTrustStore";
    private static final String HIVE_SSL_TRUST_STORE_PASSWORD = "trustStorePassword";
    private final Map<String, String> sessConfMap;
    private final Map<String, String> hiveConfMap;
    private final Map<String, String> hiveVarMap;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int loginTimeout = 0;
    private String serverName = "Hive";

    public HiveConnection(String uri, Properties info) throws SQLException {
        Utils.JdbcConnectionParams connParams;
        this.setupLoginTimeout();
        try {
            connParams = Utils.parseURL(uri);
            this.sessConfMap = connParams.getSessionVars();
            this.hiveConfMap = connParams.getHiveConfs();
            this.hiveVarMap = connParams.getHiveVars();
            this.isEmbeddedMode = connParams.isEmbeddedMode();
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        if (this.isEmbeddedMode) {
            this.client = new EmbeddedThriftCLIService();
        } else {
            if (info.containsKey(HIVE_AUTH_USER)) {
                this.sessConfMap.put(HIVE_AUTH_USER, info.getProperty(HIVE_AUTH_USER));
                if (info.containsKey(HIVE_AUTH_PASSWD)) {
                    this.sessConfMap.put(HIVE_AUTH_PASSWD, info.getProperty(HIVE_AUTH_PASSWD));
                }
            }
            if (info.containsKey(HIVE_AUTH_TYPE)) {
                this.sessConfMap.put(HIVE_AUTH_TYPE, info.getProperty(HIVE_AUTH_TYPE));
            }
            this.openTransport(uri, connParams.getHost(), connParams.getPort(), this.sessConfMap);
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.openSession(uri, this.sessConfMap);
        this.configureConnection(connParams.getDbName());
    }

    private void openTransport(String uri, String host, int port, Map<String, String> sessConf) throws SQLException {
        block16: {
            try {
                if (!sessConf.containsKey(HIVE_AUTH_TYPE) || !sessConf.get(HIVE_AUTH_TYPE).equals(HIVE_AUTH_SIMPLE)) {
                    if (sessConf.containsKey(HIVE_AUTH_PRINCIPAL)) {
                        HashMap<String, String> saslProps = new HashMap<String, String>();
                        SaslQOP saslQOP = SaslQOP.AUTH;
                        if (sessConf.containsKey(HIVE_AUTH_QOP)) {
                            try {
                                saslQOP = SaslQOP.fromString((String)sessConf.get(HIVE_AUTH_QOP));
                            }
                            catch (IllegalArgumentException e) {
                                throw new SQLException("Invalid sasl.qop parameter. " + e.getMessage(), "42000", e);
                            }
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                        saslProps.put("javax.security.sasl.server.authentication", "true");
                        this.transport = KerberosSaslHelper.getKerberosTransport((String)sessConf.get(HIVE_AUTH_PRINCIPAL), (String)host, (TTransport)HiveAuthFactory.getSocketTransport((String)host, (int)port, (int)this.loginTimeout), saslProps);
                        break block16;
                    }
                    String tokenStr = this.getClientDelegationToken(sessConf);
                    if (tokenStr != null) {
                        this.transport = KerberosSaslHelper.getTokenTransport((String)tokenStr, (String)host, (TTransport)HiveAuthFactory.getSocketTransport((String)host, (int)port, (int)this.loginTimeout));
                    } else {
                        String useSslStr;
                        String passwd;
                        String userName = sessConf.get(HIVE_AUTH_USER);
                        if (userName == null || userName.isEmpty()) {
                            userName = "anonymous";
                        }
                        if ((passwd = sessConf.get(HIVE_AUTH_PASSWD)) == null || passwd.isEmpty()) {
                            passwd = "anonymous";
                        }
                        if ("true".equalsIgnoreCase(useSslStr = sessConf.get(HIVE_USE_SSL))) {
                            String sslTrustStore = sessConf.get(HIVE_SSL_TRUST_STORE);
                            String sslTrustStorePassword = sessConf.get(HIVE_SSL_TRUST_STORE_PASSWORD);
                            this.transport = sslTrustStore == null || sslTrustStore.isEmpty() ? HiveAuthFactory.getSSLSocket((String)host, (int)port, (int)this.loginTimeout) : HiveAuthFactory.getSSLSocket((String)host, (int)port, (int)this.loginTimeout, (String)sslTrustStore, (String)sslTrustStorePassword);
                        } else {
                            this.transport = HiveAuthFactory.getSocketTransport((String)host, (int)port, (int)this.loginTimeout);
                        }
                        this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)this.transport);
                    }
                    break block16;
                }
                this.transport = HiveAuthFactory.getSocketTransport((String)host, (int)port, (int)this.loginTimeout);
            }
            catch (SaslException e) {
                throw new SQLException("Could not establish secure connection to " + uri + ": " + e.getMessage(), " 08S01", e);
            }
            catch (TTransportException e) {
                throw new SQLException("Could not create connection to " + uri + ": " + e.getMessage(), " 08S01", e);
            }
        }
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new TCLIService.Client((TProtocol)protocol);
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new SQLException("Could not establish connection to " + uri + ": " + e.getMessage(), " 08S01", e);
        }
    }

    private String getClientDelegationToken(Map<String, String> jdbcConnConf) throws SQLException {
        String tokenStr = null;
        if (HIVE_AUTH_TOKEN.equalsIgnoreCase(jdbcConnConf.get(HIVE_AUTH_TYPE))) {
            try {
                tokenStr = ShimLoader.getHadoopShims().getTokenStrForm("hiveserver2ClientToken");
            }
            catch (IOException e) {
                throw new SQLException("Error reading token ", e);
            }
        }
        return tokenStr;
    }

    private void openSession(String uri, Map<String, String> sessVars) throws SQLException {
        TOpenSessionReq openReq = new TOpenSessionReq();
        if (sessVars.containsKey("hive.server2.proxy.user")) {
            HashMap<String, String> openConf = new HashMap<String, String>();
            openConf.put("hive.server2.proxy.user", sessVars.get("hive.server2.proxy.user"));
            openReq.setConfiguration(openConf);
        }
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.sessHandle = openResp.getSessionHandle();
        }
        catch (TException e) {
            throw new SQLException("Could not establish connection to " + uri + ": " + e.getMessage(), " 08S01", e);
        }
        this.isClosed = false;
    }

    private void configureConnection(String dbName) throws SQLException {
        if (this.isEmbeddedMode) {
            if (!this.hiveVarMap.isEmpty()) {
                SessionState.get().setHiveVariables(this.hiveVarMap);
            }
        } else {
            Statement stmt = this.createStatement();
            for (Map.Entry<String, String> hiveConf : this.hiveConfMap.entrySet()) {
                stmt.execute("set " + hiveConf.getKey() + "=" + hiveConf.getValue());
            }
            for (Map.Entry<String, String> hiveVar : this.hiveVarMap.entrySet()) {
                stmt.execute("set hivevar:" + hiveVar.getKey() + "=" + hiveVar.getValue());
            }
            if (!"default".equalsIgnoreCase(dbName)) {
                stmt.execute("use " + dbName);
            }
            stmt.close();
        }
    }

    private String getUserName() {
        return this.getSessionValue(HIVE_AUTH_USER, "anonymous");
    }

    private String getPasswd() {
        return this.getSessionValue(HIVE_AUTH_PASSWD, "anonymous");
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupLoginTimeout() {
        long timeOut = TimeUnit.SECONDS.toMillis(DriverManager.getLoginTimeout());
        this.loginTimeout = timeOut > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeOut;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new SQLException("Could not retrieve token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not cancel token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not renew token: " + e.getMessage(), " 08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this.client, this.sessHandle, this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Method not supported");
        }
        if (resultSetType == 1005) {
            throw new SQLException("Method not supported");
        }
        return new HiveStatement(this.client, this.sessHandle, this, resultSetType == 1004);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HiveDatabaseMetaData(this.client, this.sessHandle, this);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            throw new SQLException("enabling autocommit is not supported");
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadExtendedErrorMsg(TOperationHandle opHandle, TStatus opStatus) {
        if (this.needExtendedErrorFromServer() && Utils.isErrorStatus(opStatus, true)) {
            TGetLogReq logReq = new TGetLogReq(opHandle);
            try {
                TGetLogResp logResp = this.client.GetLog(logReq);
                if (logResp.getStatus().getStatusCode() != TStatusCode.SUCCESS_STATUS) {
                    opStatus.addToInfoMessages("Failed to extract additional diagnostics from serverdue to rrror " + logResp.getStatus().getErrorMessage());
                    return;
                }
                opStatus.setErrorMessage(logResp.getLog());
            }
            catch (TException e) {
                opStatus.addToInfoMessages("Error retrieving additional diagnostics from server " + e.toString());
            }
            finally {
                if (opStatus.getSqlState() == null || opStatus.getSqlState().isEmpty()) {
                    opStatus.setSqlState("HY000");
                }
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    private void retrieveServerName(Map<String, String> sessConf) throws SQLException {
        block2: {
            try {
                TGetInfoReq req = new TGetInfoReq(this.sessHandle, TGetInfoType.CLI_SERVER_NAME);
                TGetInfoResp infoResp = this.client.GetInfo(req);
                this.serverName = infoResp.getInfoValue().getStringValue();
            }
            catch (Exception e) {
                if (!"true".equalsIgnoreCase(sessConf.get("verifyServer"))) break block2;
                throw new SQLException("Failed to retrieve server type using GetInfo()", e);
            }
        }
    }

    protected boolean needExtendedErrorFromServer() {
        return this.serverName.toUpperCase().contains("IMPALA");
    }
}

