/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.tbutils.res;

import com.tonbeller.tbutils.res.CompositeResourceProvider;
import com.tonbeller.tbutils.res.Dumper;
import com.tonbeller.tbutils.res.FilePersistentResourceProvider;
import com.tonbeller.tbutils.res.PersistentResourceProvider;
import com.tonbeller.tbutils.res.ReplacingResourceProvider;
import com.tonbeller.tbutils.res.ResourcesFactory;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;

public class Resources {
    private ReplacingResourceProvider provider;
    private Locale locale;
    private File home;
    private PersistentResourceProvider persistentProvider;
    private CompositeResourceProvider compositeProvider;
    static final String PERSISTENT_PROPERTIES = "persistent.properties";

    public static Resources instance() {
        return ResourcesFactory.instance().getResources(null, null);
    }

    public static Resources instance(Locale browserLocale) {
        return ResourcesFactory.instance().getResources(browserLocale, null);
    }

    public static Resources instance(Locale browserLocale, Class clazz) {
        return ResourcesFactory.instance().getResources(browserLocale, clazz.getPackage().getName() + ".resources");
    }

    public static Resources instance(Class clazz) {
        return ResourcesFactory.instance().getResources(Locale.getDefault(), clazz.getPackage().getName() + ".resources");
    }

    public static Resources instance(Locale browserLocale, String bundleName) {
        return ResourcesFactory.instance().getResources(browserLocale, bundleName);
    }

    Resources(CompositeResourceProvider compositeProvider, Locale locale, File home) {
        this.locale = locale;
        this.home = home;
        this.compositeProvider = compositeProvider;
        File persistentProperties = new File(home, PERSISTENT_PROPERTIES);
        this.persistentProvider = new FilePersistentResourceProvider(persistentProperties);
        compositeProvider.add(0, this.persistentProvider);
        this.provider = new ReplacingResourceProvider(compositeProvider);
    }

    public String getOptionalString(String key, String defaultValue) {
        String s = this.provider.getString(key);
        if (s == null) {
            return defaultValue;
        }
        return s.trim();
    }

    public String getString(String key) throws MissingResourceException {
        String s = this.provider.getString(key);
        if (s == null) {
            throw new MissingResourceException("missing resource for " + key, this.getClass().getName(), key);
        }
        return s.trim();
    }

    public String getString(String key, Object arg) throws MissingResourceException {
        String fmt = this.getString(key);
        return MessageFormat.format(fmt, arg);
    }

    public String getString(String key, Object arg0, Object arg1) throws MissingResourceException {
        String fmt = this.getString(key);
        return MessageFormat.format(fmt, arg0, arg1);
    }

    public String getString(String key, Object[] args) throws MissingResourceException {
        String fmt = this.getString(key);
        return MessageFormat.format(fmt, args);
    }

    public boolean getBoolean(String key) throws MissingResourceException {
        String s = this.getString(key);
        return "true".equals(s) || "on".equals(s) || "yes".equals(s);
    }

    public boolean getOptionalBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public int getInteger(String key) throws MissingResourceException {
        String s = this.getString(key);
        return Integer.parseInt(s);
    }

    public int getOptionalInteger(String key, int defaultValue) {
        try {
            return this.getInteger(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public long getLong(String key) throws MissingResourceException {
        String s = this.getString(key);
        return Long.parseLong(s);
    }

    public long getOptionalLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public double getDouble(String key) throws MissingResourceException {
        String s = this.getString(key);
        return Double.parseDouble(s);
    }

    public double getOptionalDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public Collection keySet() {
        return this.provider.keySet();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public File getHomeDir() {
        return this.home;
    }

    public void setPersistentString(String key, String value) {
        this.persistentProvider.store(key, value);
    }

    public void setPersistentBoolean(String key, boolean value) {
        this.persistentProvider.store(key, value ? "true" : "false");
    }

    public void setPersistentInteger(String key, int value) {
        this.persistentProvider.store(key, Integer.toString(value));
    }

    public void setPersistentLong(String key, long value) {
        this.persistentProvider.store(key, Long.toString(value));
    }

    public void setPersistentDouble(String key, double value) {
        this.persistentProvider.store(key, Double.toString(value));
    }

    public void removePersistent(String key) {
        this.persistentProvider.remove(key);
    }

    public void flush() {
        this.persistentProvider.flush();
    }

    public void dump(Dumper d) {
        this.provider.dump(d);
    }

    public String replace(String s) {
        return this.provider.replace(s);
    }

    public List getProviders() {
        return this.compositeProvider.getProviders();
    }
}

