/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.utils;

import java.util.EnumMap;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class MimeTypes {
    public static final String CSS = "text/css";
    public static final String JAVASCRIPT = "text/javascript";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String HTML = "text/html";
    public static final String XML = "text/xml";
    public static final String JPEG = "img/jpeg";
    public static final String PNG = "image/png";
    public static final String GIF = "image/gif";
    public static final String BMP = "image/bmp";
    public static final String JSON = "application/json";
    public static final String PDF = "application/pdf";
    public static final String DOC = "application/msword";
    public static final String DOCX = "application/msword";
    public static final String XLS = "application/msexcel";
    public static final String XLSX = "application/msexcel";
    public static final String PPT = "application/mspowerpoint";
    public static final String PPTX = "application/mspowerpoint";
    public static final String ZIP = "application/zip";
    public static final String CSV = "text/csv";
    protected static final EnumMap<FileType, String> mimeTypes = new EnumMap(FileType.class);

    public static String getMimeType(String fileName) {
        String extension = RepositoryHelper.getExtension(fileName);
        return MimeTypes.getMimeTypeFromExt(extension);
    }

    public static String getMimeTypeFromExt(String extension) {
        FileType type = FileType.parse(extension, null);
        return MimeTypes.getMimeType(type);
    }

    public static String getMimeType(FileType fileType) {
        return MimeTypes.getMimeType(fileType, "application/unknown");
    }

    public static String getMimeType(FileType fileType, String defaultMimeType) {
        if (fileType == null) {
            return defaultMimeType;
        }
        String mimeType = mimeTypes.get((Object)fileType);
        return mimeType == null ? defaultMimeType : mimeType;
    }

    static {
        mimeTypes.put(FileType.JPG, JPEG);
        mimeTypes.put(FileType.JPEG, JPEG);
        mimeTypes.put(FileType.PNG, PNG);
        mimeTypes.put(FileType.GIF, GIF);
        mimeTypes.put(FileType.BMP, BMP);
        mimeTypes.put(FileType.JS, JAVASCRIPT);
        mimeTypes.put(FileType.HTM, HTML);
        mimeTypes.put(FileType.HTML, HTML);
        mimeTypes.put(FileType.CSS, CSS);
        mimeTypes.put(FileType.CSV, CSV);
        mimeTypes.put(FileType.XML, XML);
        mimeTypes.put(FileType.TXT, PLAIN_TEXT);
        mimeTypes.put(FileType.CDA, XML);
        mimeTypes.put(FileType.CDFDE, JSON);
        mimeTypes.put(FileType.XCDF, XML);
        mimeTypes.put(FileType.WCDF, XML);
    }

    public static enum FileType {
        JPG,
        JPEG,
        PNG,
        GIF,
        BMP,
        JS,
        CSS,
        HTML,
        HTM,
        XML,
        SVG,
        PDF,
        TXT,
        DOC,
        DOCX,
        XLS,
        XLSX,
        PPT,
        PPTX,
        ZIP,
        CSV,
        CDA,
        CDFDE,
        WCDF,
        XCDF;


        public static FileType parse(String value) {
            return FileType.parse(value, null);
        }

        public static FileType parse(String value, FileType defaultType) {
            try {
                return FileType.valueOf(StringUtils.upperCase((String)value));
            }
            catch (IllegalArgumentException e) {
                return defaultType;
            }
        }
    }
}

