/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class RepositoryHelper {
    private static Log logger = LogFactory.getLog(RepositoryHelper.class);
    public static final char SEPARATOR = '/';

    private RepositoryHelper() {
    }

    public static String appendPath(String first, String second) {
        if (StringUtils.isEmpty((String)first)) {
            return second;
        }
        if (StringUtils.isEmpty((String)second)) {
            return first;
        }
        int sepCount = 0;
        if (first.charAt(first.length() - 1) == '/') {
            ++sepCount;
        }
        if (second.charAt(0) == '/') {
            ++sepCount;
        }
        switch (sepCount) {
            case 0: {
                return first + '/' + second;
            }
            case 2: {
                return first + second.substring(1);
            }
        }
        return first + second;
    }

    public static StringBuilder appendPath(StringBuilder builder, String path) {
        int sepCount = 0;
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '/') {
            ++sepCount;
        }
        if (path.charAt(0) == '/') {
            ++sepCount;
        }
        switch (sepCount) {
            case 2: {
                return builder.append(path.substring(1));
            }
            case 0: {
                builder.append('/');
            }
        }
        return builder.append(path);
    }

    public static String joinPaths(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (StringUtils.isEmpty((String)path)) continue;
            RepositoryHelper.appendPath(builder, path);
        }
        return builder.toString();
    }

    public static String joinPaths(List<String> paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            if (StringUtils.isEmpty((String)path)) continue;
            RepositoryHelper.appendPath(builder, path);
        }
        return builder.toString();
    }

    public static URL getClosestResource(ClassLoader classLoader, String path) {
        URL resource = null;
        try {
            Enumeration<URL> resourceCandidates = classLoader.getResources(path);
            while (resourceCandidates.hasMoreElements()) {
                resource = resourceCandidates.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource;
    }

    public static String relativizePath(String basePath, String fullPath, boolean assumeCommon) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)fullPath));
        String normalizedBasePath = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)basePath));
        if (StringUtils.isEmpty((String)normalizedBasePath)) {
            return fullPath;
        }
        if (StringUtils.isEmpty((String)normalizedTargetPath)) {
            return basePath;
        }
        String[] base = StringUtils.split((String)normalizedBasePath, (char)'/');
        String[] target = StringUtils.split((String)normalizedTargetPath, (char)'/');
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex]);
            common.append('/');
        }
        if (commonIndex == 0 && !assumeCommon) {
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        if (normalizedBasePath.startsWith("/") && normalizedTargetPath.startsWith("/")) {
            common.insert(0, '/');
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append("../");
            }
        }
        if (common.length() < normalizedTargetPath.length()) {
            relative.append(normalizedTargetPath.substring(common.length()));
        }
        return relative.toString();
    }

    public static String normalize(String path) {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)path));
    }

    public static String getPathNoEndSeparator(String path) {
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.getPathNoEndSeparator((String)path));
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.startsWith(".")) {
            return StringUtils.lowerCase((String)FilenameUtils.getExtension((String)fileName.substring(1)));
        }
        return StringUtils.lowerCase((String)FilenameUtils.getExtension((String)fileName));
    }

    public static String toJQueryFileTree(String baseDir, IBasicFile[] files) {
        StringBuilder out = new StringBuilder();
        out.append("<ul class=\"jqueryFileTree\" style=\"display: none;\">");
        for (IBasicFile file : files) {
            if (!file.isDirectory()) continue;
            out.append("<li class=\"directory collapsed\"><a href=\"#\" rel=\"" + file.getPath() + "/\">" + file.getName() + "</a></li>");
        }
        for (IBasicFile file : files) {
            if (file.isDirectory()) continue;
            out.append("<li class=\"file ext_" + file.getExtension() + "\"><a href=\"#\" rel=\"" + file.getPath() + "\">" + file.getName() + "</a></li>");
        }
        out.append("</ul>");
        return out.toString();
    }

    public static String toJSON(String baseDir, IBasicFile[] files) throws JSONException {
        JSONArray arr = new JSONArray();
        for (IBasicFile file : files) {
            JSONObject json = new JSONObject();
            json.put("path", (Object)baseDir);
            json.put("name", (Object)file.getName());
            json.put("label", (Object)file.getName());
            if (file.isDirectory()) {
                json.put("type", (Object)"dir");
            } else {
                int dotIndex = file.getName().lastIndexOf(46);
                String ext = dotIndex > 0 ? file.getName().substring(dotIndex + 1) : "";
                json.put("ext", (Object)ext);
                json.put("type", (Object)"file");
            }
            arr.put((Object)json);
        }
        return arr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(IReadAccess reader, String inFile, IRWAccess writer, String outFile) {
        InputStream input = null;
        try {
            input = reader.getFileInputStream(inFile);
            boolean bl = writer.saveFile(outFile, input);
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)("Couldn't read " + inFile + " in " + reader));
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static IBasicFileFilter getSimpleExtensionFilter(final String extension) {
        return new IBasicFileFilter(){

            @Override
            public boolean accept(IBasicFile file) {
                return StringUtils.equals((String)extension, (String)file.getExtension());
            }
        };
    }
}

