/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.robochef;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.swing.table.TableModel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import pt.webdetails.robochef.RowProducerBridge;

public class TableModelInput
extends RowProducerBridge {
    public synchronized Callable<Boolean> getCallableRowProducer(final TableModel tableModel, final boolean markFinished) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                RowMetaInterface rowMeta = TableModelInput.this.getRowMetaForTableModel(tableModel);
                TableModelInput.this.start(rowMeta);
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    Object[] row = new Object[tableModel.getColumnCount()];
                    for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                        row[j] = TableModelInput.this.getDataObjectForColumn(rowMeta.getValueMeta(j), tableModel.getValueAt(i, j));
                    }
                    TableModelInput.this.putRow(row);
                }
                if (markFinished) {
                    TableModelInput.this.finish();
                }
                return true;
            }
        };
        return callable;
    }

    private Object getDataObjectForColumn(ValueMetaInterface valueMeta, Object value) {
        Object newValue;
        if (value == null) {
            return null;
        }
        switch (valueMeta.getType()) {
            case 2: {
                newValue = String.valueOf(value);
                break;
            }
            case 1: {
                if (value instanceof Double) {
                    newValue = value;
                    break;
                }
                newValue = Double.valueOf(value.toString());
                break;
            }
            case 5: {
                if (value instanceof Long) {
                    newValue = value;
                    break;
                }
                newValue = Long.valueOf(value.toString());
                break;
            }
            case 3: {
                newValue = value;
                break;
            }
            case 6: {
                if (value instanceof BigDecimal) {
                    newValue = value;
                    break;
                }
                newValue = BigDecimal.valueOf(((BigInteger)value).doubleValue());
                break;
            }
            case 4: {
                newValue = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ValueMeta mismatch %s (%s)", valueMeta.toString(), value));
            }
        }
        return newValue;
    }

    private RowMetaInterface getRowMetaForTableModel(TableModel tableModel) throws IllegalArgumentException {
        RowMeta rowMeta = new RowMeta();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Class<?> columnClass;
            for (columnClass = tableModel.getColumnClass(i); columnClass != Object.class; columnClass = columnClass.getSuperclass()) {
                if (columnClass == String.class) {
                    rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 2));
                    break;
                }
                if (columnClass == Date.class) {
                    rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 3));
                    break;
                }
                if (columnClass == Boolean.class) {
                    rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 4));
                    break;
                }
                if (columnClass == BigDecimal.class || columnClass == BigInteger.class) {
                    rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 6));
                    break;
                }
                if (columnClass == Long.class || columnClass == Short.class || columnClass == Integer.class || columnClass == Byte.class) {
                    rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 5));
                    break;
                }
                if (columnClass != Double.class && columnClass != Float.class) continue;
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 1));
                break;
            }
            if (columnClass != Object.class) continue;
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(tableModel.getColumnName(i), 2));
        }
        return rowMeta;
    }
}

