/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.robochef;

import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;

public abstract class RowProducerBridge {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private RowMetaInterface rowMeta;
    private RowProducer rowProducer;

    public void setRowProducer(RowProducer rowProducer) {
        this.rowProducer = rowProducer;
    }

    public void start(RowMetaInterface rowMeta) {
        if (this.rowProducer == null) {
            throw new IllegalStateException("RowProducer is null and RowProducerBridge.start() was called.");
        }
        if (rowMeta == null) {
            throw new IllegalStateException("RowMeta is null");
        }
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("RowProducerBridge was already started");
        }
        this.rowMeta = rowMeta;
    }

    public void putRow(Object[] row) {
        if (!this.started.get()) {
            throw new IllegalStateException("RowProducerBridge not started");
        }
        if (this.finished.get()) {
            throw new IllegalStateException("RowProducerBridge already finished");
        }
        this.rowProducer.putRow(this.rowMeta, row);
    }

    public void finish() {
        this.finished.set(true);
        this.rowProducer.finished();
    }
}

