/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.robochef;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Node;
import pt.webdetails.robochef.DynamicTransConfig;
import pt.webdetails.robochef.DynamicTransMetaConfig;
import pt.webdetails.robochef.RowProducerBridge;
import pt.webdetails.robochef.RowProductionManager;

public class DynamicTransformation {
    private State state = State.INVALID;
    private final TransMeta transMeta;
    private final Trans trans;
    private final DynamicTransConfig transConfig;
    private int secondsDuration;
    private Result result;
    private static boolean hasCheckedForMethod = false;
    private static Method logCleaningMethod = null;
    private static boolean isInitialized = false;
    private static boolean isInitializedWithJDNI = false;

    public State getState() {
        return this.state;
    }

    public static synchronized void init(boolean initializeJNDI) {
        if (!isInitialized) {
            try {
                KettleEnvironment.init((boolean)initializeJNDI);
                isInitialized = true;
                isInitializedWithJDNI = initializeJNDI;
            }
            catch (KettleException e) {
                throw new IllegalStateException(e);
            }
        }
        if (initializeJNDI && !isInitializedWithJDNI) {
            throw new IllegalStateException("DynamicTransformation was already initialized without JNDI. Call init(true) before new DynamicTransformation()");
        }
    }

    public DynamicTransformation(DynamicTransConfig transConfig, DynamicTransMetaConfig transMetaConfig) throws KettleException {
        DynamicTransformation.init(false);
        if (transConfig == null) {
            throw new IllegalArgumentException("config is null");
        }
        transConfig.freeze();
        this.transConfig = transConfig;
        if (transMetaConfig == null) {
            throw new IllegalArgumentException("config is null");
        }
        VariableSpace parentVariableSpace = Variables.getADefaultVariableSpace();
        parentVariableSpace.injectVariables(transConfig.getFrozenVariableConfigEntries());
        this.transMeta = transMetaConfig.getTransMeta(parentVariableSpace);
        for (Map.Entry<String, String> entry : transConfig.getFrozenStepConfigEntries().entrySet()) {
            StepMeta stepMeta = new StepMeta(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)entry.getValue()), (String)"step"), this.transMeta.getDatabases(), (Map)this.transMeta.getCounters());
            this.transMeta.addOrReplaceStep(stepMeta);
        }
        List steps = this.transMeta.getSteps();
        for (Map.Entry<String, String> entry : transConfig.getFrozenStepErrorHandlingConfigEntries().entrySet()) {
            StepErrorMeta stepErrorMeta = new StepErrorMeta((VariableSpace)this.transMeta, XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)entry.getValue()), (String)"error"), steps);
            stepErrorMeta.getSourceStep().setStepErrorMeta(stepErrorMeta);
        }
        for (StepMeta stepMeta : steps) {
            StepMetaInterface sii = stepMeta.getStepMetaInterface();
            if (sii == null) continue;
            sii.searchInfoAndTargetSteps(steps);
        }
        for (Map.Entry<String, String> entry : transConfig.getFrozenHopConfigEntries().entrySet()) {
            TransHopMeta hop = new TransHopMeta(this.transMeta.findStep(entry.getKey()), this.transMeta.findStep(entry.getValue()));
            this.transMeta.addTransHop(hop);
        }
        this.trans = new Trans(this.transMeta);
        this.trans.setLogLevel(LogLevel.NOTHING);
        this.state = State.CREATED;
    }

    public String getStatus() {
        return this.trans.getStatus();
    }

    public void executeCheckedSuccess(String[] arguments, Map<String, String> parameters, RowProductionManager rowProductionManager) throws KettleException {
        if (!this.execute(arguments, parameters, rowProductionManager)) {
            throw new KettleException(String.format("The transformation execution ended with state %s (%d errors)", new Object[]{this.state, this.result.getNrErrors()}));
        }
    }

    public boolean execute(String[] arguments, Map<String, String> parameters, RowProductionManager rowProductionManager) throws KettleException {
        if (rowProductionManager == null) {
            throw new IllegalArgumentException("rowProductionManager is null");
        }
        long startMillis = System.currentTimeMillis();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.trans.setParameterValue(entry.getKey(), entry.getValue());
            }
        }
        this.trans.prepareExecution(arguments);
        for (Map.Entry<String, String> entry : this.transConfig.getFrozenOutputs().entrySet()) {
            StepInterface si = this.trans.getStepInterface(entry.getKey(), 0);
            si.addRowListener((RowListener)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.transConfig.getFrozenInputs().entrySet()) {
            RowProducerBridge bridge = (RowProducerBridge)entry.getValue();
            bridge.setRowProducer(this.trans.addRowProducer(entry.getKey(), 0));
        }
        this.trans.startThreads();
        this.state = State.RUNNING;
        rowProductionManager.startRowProduction();
        this.trans.waitUntilFinished();
        this.secondsDuration = (int)(System.currentTimeMillis() - startMillis);
        this.result = this.trans.getResult();
        this.state = this.result.getNrErrors() == 0L ? State.FINISHED_SUCCESS : State.FINISHED_ERROR;
        this.trans.cleanup();
        this.cleanLogs(this.trans.getLogChannelId());
        this.cleanLogs(this.transMeta.getLogChannelId());
        return this.state == State.FINISHED_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanLogs(String logChannelId) {
        CentralLogStore.init();
        CentralLogStore.discardLines((String)logChannelId, (boolean)true);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!hasCheckedForMethod) {
                hasCheckedForMethod = true;
                Class<LoggingRegistry> c = LoggingRegistry.class;
                Class[] parTypes = new Class[]{String.class};
                try {
                    logCleaningMethod = c.getDeclaredMethod("removeIncludingChildren", parTypes);
                }
                catch (NoSuchMethodException nsme) {
                    logCleaningMethod = null;
                }
            }
        }
        if (logCleaningMethod != null) {
            Object[] parameters = new Object[]{logChannelId};
            try {
                logCleaningMethod.invoke((Object)LoggingRegistry.getInstance(), parameters);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public String getReadWriteThroughput() {
        String throughput = null;
        if (this.secondsDuration != 0) {
            String readClause = null;
            String writtenClause = null;
            if (this.result.getNrLinesRead() > 0L) {
                readClause = String.format("lines read: %d ( %d lines/s)", this.result.getNrLinesRead(), this.result.getNrLinesRead() / (long)this.secondsDuration);
            }
            if (this.result.getNrLinesWritten() > 0L) {
                writtenClause = String.format("%slines written: %d ( %d lines/s)", this.result.getNrLinesRead() > 0L ? "; " : "", this.result.getNrLinesWritten(), this.result.getNrLinesWritten() / (long)this.secondsDuration);
            }
            if (readClause != null || writtenClause != null) {
                throughput = String.format("Transformation %s%s", this.result.getNrLinesRead() > 0L ? readClause : "", this.result.getNrLinesWritten() > 0L ? writtenClause : "");
            }
        }
        return throughput;
    }

    public static enum State {
        INVALID,
        CREATED,
        RUNNING,
        FINISHED_SUCCESS,
        FINISHED_ERROR;

    }
}

