/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.robochef;

import java.io.File;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.w3c.dom.Node;

public class DynamicTransMetaConfig {
    private final TransMeta transMeta;

    public DynamicTransMetaConfig(Type type, String name, String configDataSource, RepositoryConfig rc) throws KettleException {
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (Const.isEmpty((String)Const.trim((String)name))) {
            throw new IllegalArgumentException("Name is null");
        }
        switch (type) {
            case EMPTY: {
                this.transMeta = new TransMeta();
                this.transMeta.setRepository(this.connectToRepository(rc));
                break;
            }
            case XML_FILE: {
                this.transMeta = new TransMeta(configDataSource, this.connectToRepository(rc));
                break;
            }
            case XML_STRING: {
                this.transMeta = new TransMeta(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)configDataSource), (String)"transformation"), this.connectToRepository(rc));
                break;
            }
            case REPOSITORY: {
                if (rc == null) {
                    throw new IllegalArgumentException("Type.REPOSITORY must have RepositoryConfig object");
                }
                Repository rep = this.connectToRepository(rc);
                File transPath = new File(configDataSource);
                if (Const.isEmpty((String)transPath.getName())) {
                    throw new IllegalArgumentException("Type.REPOSITORY configDataSource must have path to transformation");
                }
                RepositoryDirectoryInterface directory = rep.loadRepositoryDirectoryTree();
                if (!Const.isEmpty((String)transPath.getParent())) {
                    directory = directory.findDirectory(transPath.getParent());
                }
                if (directory == null) {
                    throw new IllegalArgumentException(String.format("Directory %s not found in repository %s", transPath.getParent(), rc.repositoryName));
                }
                this.transMeta = rep.loadTransformation(transPath.getName(), directory, null, true, rc.version);
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown Type %s", new Object[]{type}));
            }
        }
        this.transMeta.setName(name);
    }

    private Repository connectToRepository(RepositoryConfig rc) throws KettleException {
        if (rc == null) {
            return null;
        }
        RepositoriesMeta reppsitoriesMeta = new RepositoriesMeta();
        if (!reppsitoriesMeta.readData()) {
            throw new IllegalArgumentException("No repositories defined");
        }
        RepositoryMeta repositoryMeta = reppsitoriesMeta.findRepository(rc.repositoryName);
        if (repositoryMeta == null) {
            throw new IllegalArgumentException(String.format("Repository %s not found", rc.repositoryName));
        }
        Repository rep = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        rep.init(repositoryMeta);
        rep.connect(rc.userName, rc.password);
        return rep;
    }

    protected TransMeta getTransMeta(VariableSpace variableSpace) throws KettleException {
        this.transMeta.initializeVariablesFrom(variableSpace);
        return this.transMeta;
    }

    public static class RepositoryConfig {
        public final String repositoryName;
        public final String userName;
        public final String password;
        public final String directory;
        public final String transformation;
        public final String version;

        public RepositoryConfig(String repositoryName, String userName, String password, String directory, String transformation, String version) {
            this.repositoryName = repositoryName;
            this.userName = userName;
            this.password = password;
            this.directory = directory;
            this.transformation = transformation;
            this.version = version;
        }

        public static RepositoryConfig get(String repositoryName, String userName, String password, String directory, String transformation, String version) {
            if (Const.isEmpty((String)Const.trim((String)repositoryName)) || Const.isEmpty((String)Const.trim((String)userName)) || password == null || Const.isEmpty((String)Const.trim((String)directory)) || Const.isEmpty((String)Const.trim((String)transformation)) || Const.isEmpty((String)Const.trim((String)version))) {
                throw new IllegalArgumentException("Invalid RepositoryConfig");
            }
            return new RepositoryConfig(repositoryName, userName, password, directory, transformation, version);
        }
    }

    public static enum Type {
        EMPTY,
        XML_FILE,
        XML_STRING,
        REPOSITORY;

    }
}

