/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.DataAccessEnums;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.utils.CalculatedTableModel;
import pt.webdetails.cda.utils.DataTableFilter;
import pt.webdetails.cda.utils.InvalidOutputIndexException;
import pt.webdetails.cda.utils.MetadataTableModel;
import pt.webdetails.cda.utils.kettle.SortException;
import pt.webdetails.cda.utils.kettle.SortTableModel;

public class TableModelUtils {
    private static final Log logger = LogFactory.getLog(TableModelUtils.class);
    private static final String DT_FILTER = "dtFilter";
    private static final String DT_SEARCHABLE = "dtSearchableColumns";
    private static TableModelUtils _instance;

    @Deprecated
    public TableModelUtils() {
    }

    @Deprecated
    public static synchronized TableModelUtils getInstance() {
        if (_instance == null) {
            _instance = new TableModelUtils();
        }
        return _instance;
    }

    public static TableModel postProcessTableModel(DataAccess dataAccess, QueryOptions queryOptions, TableModel rawTableModel) throws SortException, InvalidOutputIndexException {
        if (rawTableModel == null) {
            throw new IllegalArgumentException("Cannot process null table.");
        }
        TableModel table = TableModelUtils.evaluateCalculatedColumns(dataAccess, rawTableModel);
        List<Integer> outputIndexes = TableModelUtils.getOutputIndexes(dataAccess, queryOptions, table);
        DataTableFilter rowFilter = TableModelUtils.getRowFilter(queryOptions, outputIndexes);
        boolean useOutputIndexes = true;
        if (table.getRowCount() == 0 && (dataAccess.getType().equals("mdx") || dataAccess.getType().equals("denormalizedMdx"))) {
            useOutputIndexes = false;
            logger.warn((Object)"Mdx query returned empty result set, output indexes will be ignored.");
        }
        TableModel tableModel = table = useOutputIndexes ? TableModelUtils.filterTable(table, outputIndexes, rowFilter) : TableModelUtils.filterTable(table, new ArrayList<Integer>(), rowFilter);
        if (!queryOptions.getSortBy().isEmpty()) {
            table = new SortTableModel().doSort(table, queryOptions.getSortBy());
        }
        Class[] colTypes = new Class[table.getColumnCount()];
        String[] colNames = new String[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            colTypes[i] = table.getColumnClass(i);
            colNames[i] = table.getColumnName(i);
        }
        int rowCount = table.getRowCount();
        MetadataTableModel result = new MetadataTableModel(colNames, colTypes, rowCount);
        result.setMetadata("totalRows", rowCount);
        for (int r = 0; r < rowCount; ++r) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                result.setValueAt(table.getValueAt(r, j), r, j);
            }
        }
        return TableModelUtils.paginateTableModel(result, queryOptions);
    }

    private static TableModel evaluateCalculatedColumns(DataAccess dataAccess, TableModel rawTableModel) {
        ArrayList<ColumnDefinition> columnDefinitions = dataAccess.getCalculatedColumns();
        Object table = columnDefinitions.isEmpty() ? rawTableModel : new CalculatedTableModel(rawTableModel, columnDefinitions.toArray(new ColumnDefinition[columnDefinitions.size()]), true);
        return table;
    }

    private static TableModel filterTable(TableModel table, List<Integer> outputIndexes, DataTableFilter rowFilter) throws InvalidOutputIndexException {
        int columnCount = outputIndexes.size();
        if (columnCount == 0 && rowFilter != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                outputIndexes.add(i);
            }
            columnCount = outputIndexes.size();
        }
        if (columnCount != 0) {
            if (Collections.max(outputIndexes) > table.getColumnCount() - 1) {
                String errorMessage = String.format("Output index higher than number of columns in tableModel. %s > %s", Collections.max(outputIndexes), table.getColumnCount());
                logger.error((Object)errorMessage);
                if (table.getColumnCount() > 0) {
                    throw new InvalidOutputIndexException(errorMessage, null);
                }
                logger.warn((Object)"Unable to validate output indexes because table metadata is empty. Returning table.");
                return table;
            }
            int rowCount = table.getRowCount();
            logger.debug((Object)(rowCount == 0 ? "No data found" : "Found " + rowCount + " rows"));
            Class[] colTypes = new Class[columnCount];
            String[] colNames = new String[columnCount];
            TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
            int rowIn = 0;
            int rowOut = 0;
            while (rowIn < rowCount) {
                if (rowFilter != null && !rowFilter.rowContainsSearchTerms(table, rowIn)) {
                    --rowOut;
                } else {
                    for (int j = 0; j < outputIndexes.size(); ++j) {
                        int outputIndex = outputIndexes.get(j);
                        typedTableModel.setValueAt(table.getValueAt(rowIn, outputIndex), rowOut, j);
                    }
                }
                ++rowIn;
                ++rowOut;
            }
            for (int i = 0; i < outputIndexes.size(); ++i) {
                int outputIndex = outputIndexes.get(i);
                typedTableModel.setColumnName(i, table.getColumnName(outputIndex));
                typedTableModel.setColumnType(i, table.getColumnClass(outputIndex));
            }
            return typedTableModel;
        }
        return table;
    }

    private static DataTableFilter getRowFilter(QueryOptions queryOptions, List<Integer> outputIndexes) {
        String filterText = StringUtils.trim((String)queryOptions.getExtraSettings().get(DT_FILTER));
        if (!StringUtils.isEmpty((String)filterText)) {
            int[] searchableIndexes = null;
            if (queryOptions.getExtraSettings().containsKey(DT_SEARCHABLE)) {
                try {
                    String[] unparsedIndexes = StringUtils.split((String)queryOptions.getExtraSettings().get(DT_SEARCHABLE), (char)',');
                    searchableIndexes = new int[unparsedIndexes.length];
                    if (outputIndexes.size() > 0) {
                        for (int i = 0; i < searchableIndexes.length; ++i) {
                            int idx = Integer.parseInt(unparsedIndexes[i].trim());
                            searchableIndexes[i] = outputIndexes.get(idx);
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    logger.error((Object)"dtSearchableColumns is out of bounds.");
                    searchableIndexes = null;
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("dtSearchableColumns not a comma-separated list of integers: " + queryOptions.getExtraSettings().get(DT_SEARCHABLE)));
                    searchableIndexes = null;
                }
            }
            if (searchableIndexes == null) {
                searchableIndexes = new int[outputIndexes.size()];
                for (int i = 0; i < searchableIndexes.length; ++i) {
                    searchableIndexes[i] = outputIndexes.get(i);
                }
            }
            return new DataTableFilter(filterText, searchableIndexes);
        }
        return null;
    }

    private static List<Integer> getOutputIndexes(DataAccess dataAccess, QueryOptions queryOptions, TableModel table) throws InvalidOutputIndexException {
        ArrayList<Integer> outputIndexes = dataAccess.getOutputs(queryOptions.getOutputIndexId());
        if (outputIndexes == null) {
            throw new InvalidOutputIndexException("Invalid outputIndexId: " + queryOptions.getOutputIndexId(), null);
        }
        if (dataAccess.getOutputMode(queryOptions.getOutputIndexId()) == DataAccess.OutputMode.EXCLUDE && outputIndexes.size() > 0) {
            ArrayList<Integer> newOutputIndexes = new ArrayList<Integer>();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                if (outputIndexes.contains(i)) continue;
                newOutputIndexes.add(i);
            }
            outputIndexes = newOutputIndexes;
        }
        return outputIndexes;
    }

    public static TableModel copyTableModel(DataAccess dataAccess, TableModel t) {
        ArrayList<String> namedColumns = new ArrayList<String>();
        ArrayList namedColumnsClasses = new ArrayList();
        for (int i = 0; i < t.getColumnCount(); ++i) {
            String colName = t.getColumnName(i);
            if (colName.startsWith("::table-by-index::") || colName.startsWith("::column::")) continue;
            namedColumns.add(colName);
            namedColumnsClasses.add(t.getColumnClass(i));
        }
        int count = namedColumns.size();
        Class[] colTypes = namedColumnsClasses.toArray(new Class[0]);
        String[] colNames = namedColumns.toArray(new String[0]);
        for (int i = 0; i < count; ++i) {
            colTypes[i] = t.getColumnClass(i);
            ColumnDefinition col = dataAccess.getColumnDefinition(i);
            colNames[i] = col != null ? col.getName() : t.getColumnName(i);
        }
        int rowCount = t.getRowCount();
        logger.debug((Object)(rowCount == 0 ? "No data found" : "Found " + rowCount + " rows"));
        block2: for (int i = 0; i < colTypes.length; ++i) {
            if (colTypes[i] != Object.class) continue;
            for (int k = 0; k < t.getRowCount(); ++k) {
                if (t.getValueAt(k, i) == null) continue;
                colTypes[i] = t.getValueAt(k, i).getClass();
                continue block2;
            }
        }
        TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < count; ++c) {
                typedTableModel.setValueAt(t.getValueAt(r, c), r, c);
            }
        }
        return typedTableModel;
    }

    public static TableModel dataAccessMapToTableModel(HashMap<String, DataAccess> dataAccessMap) {
        int rowCount = dataAccessMap.size();
        String[] colNames = new String[]{"id", "name", "type"};
        Class[] colTypes = new Class[]{String.class, String.class, String.class};
        TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
        TreeMap<String, DataAccess> dataAccessSortedMap = new TreeMap<String, DataAccess>(dataAccessMap);
        for (DataAccess dataAccess : dataAccessSortedMap.values()) {
            if (dataAccess.getAccess() != DataAccessEnums.ACCESS_TYPE.PUBLIC) continue;
            typedTableModel.addRow(new Object[]{dataAccess.getId(), dataAccess.getName(), dataAccess.getType()});
        }
        return typedTableModel;
    }

    public static TableModel dataAccessParametersToTableModel(ArrayList<Parameter> parameters) {
        int rowCount = parameters.size();
        String[] colNames = new String[]{"name", "type", "defaultValue", "pattern", "access"};
        Class[] colTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
        for (Parameter p : parameters) {
            typedTableModel.addRow(new Object[]{p.getName(), p.getTypeAsString(), p.getDefaultValue(), p.getPattern(), p.getAccess().toString()});
        }
        return typedTableModel;
    }

    public static TableModel appendTableModel(TableModel tableModelA, TableModel tableModelB) {
        int colCountB;
        int colCountA = tableModelA.getColumnCount();
        boolean usingA = colCountA > (colCountB = tableModelB.getColumnCount());
        int colCount = usingA ? colCountA : colCountB;
        TableModel referenceTable = usingA ? tableModelA : tableModelB;
        Class[] colTypes = new Class[colCount];
        String[] colNames = new String[colCount];
        for (int i = 0; i < referenceTable.getColumnCount(); ++i) {
            colTypes[i] = referenceTable.getColumnClass(i);
            colNames[i] = referenceTable.getColumnName(i);
        }
        int rowCount = tableModelA.getRowCount() + tableModelB.getRowCount();
        TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
        for (int r = 0; r < tableModelA.getRowCount(); ++r) {
            for (int c = 0; c < colTypes.length; ++c) {
                typedTableModel.setValueAt(tableModelA.getValueAt(r, c), r, c);
            }
        }
        int rowCountOffset = tableModelA.getRowCount();
        for (int r = 0; r < tableModelB.getRowCount(); ++r) {
            for (int c = 0; c < colTypes.length; ++c) {
                typedTableModel.setValueAt(tableModelB.getValueAt(r, c), r + rowCountOffset, c);
            }
        }
        return typedTableModel;
    }

    private static TableModel paginateTableModel(MetadataTableModel t, QueryOptions queryOptions) {
        if (!queryOptions.isPaginate() || queryOptions.getPageSize() == 0 && queryOptions.getPageStart() == 0) {
            return t;
        }
        int rowCount = Math.min(queryOptions.getPageSize(), t.getRowCount() - queryOptions.getPageStart());
        logger.debug((Object)("Paginating " + queryOptions.getPageSize() + " pages from page " + queryOptions.getPageStart()));
        Class[] colTypes = new Class[t.getColumnCount()];
        String[] colNames = new String[t.getColumnCount()];
        for (int i = 0; i < t.getColumnCount(); ++i) {
            colTypes[i] = t.getColumnClass(i);
            colNames[i] = t.getColumnName(i);
        }
        MetadataTableModel resultTableModel = new MetadataTableModel(colNames, colTypes, rowCount, t.getAllMetadata());
        resultTableModel.setMetadata("pageSize", queryOptions.getPageSize());
        resultTableModel.setMetadata("pageStart", queryOptions.getPageStart());
        for (int r = 0; r < rowCount; ++r) {
            for (int j = 0; j < t.getColumnCount(); ++j) {
                resultTableModel.setValueAt(t.getValueAt(r + queryOptions.getPageStart(), j), r, j);
            }
        }
        return resultTableModel;
    }
}

