/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.settings;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import pt.webdetails.cda.AccessDeniedException;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.UnsupportedConnectionException;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.DataAccessConnectionDescriptor;
import pt.webdetails.cda.dataaccess.UnsupportedDataAccessException;
import pt.webdetails.cda.settings.CdaRepositoryResourceLoader;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.CdaSettingsReadException;
import pt.webdetails.cda.settings.CdaSystemResourceLoader;
import pt.webdetails.cda.settings.ICdaResourceLoader;

public class SettingsManager {
    public static final String DATA_ACCESS_PACKAGE = "pt.webdetails.cda.dataaccess";
    private static final String DEFAULT_RESOURCE_LOADER_NAME = "";
    private static final String SYSTEM_RESOURCE_LOADER_NAME = "system";
    private static final Log logger = LogFactory.getLog(SettingsManager.class);
    private Map<String, CdaSettings> settingsCache;
    private Map<String, Long> settingsTimestamps;
    private ICdaResourceLoader defaultResourceLoader;
    private Map<String, ICdaResourceLoader> resourceLoaders;
    private static final int MAX_SETTINGS_CACHE_SIZE = 50;

    public SettingsManager() {
        logger.debug((Object)"Initializing SettingsManager.");
        this.settingsCache = new LRUMap(50);
        this.settingsTimestamps = new HashMap<String, Long>();
        this.defaultResourceLoader = new CdaRepositoryResourceLoader(DEFAULT_RESOURCE_LOADER_NAME);
        this.resourceLoaders = new LinkedHashMap<String, ICdaResourceLoader>();
        this.resourceLoaders.put(DEFAULT_RESOURCE_LOADER_NAME, this.defaultResourceLoader);
        this.resourceLoaders.put(SYSTEM_RESOURCE_LOADER_NAME, new CdaSystemResourceLoader(SYSTEM_RESOURCE_LOADER_NAME));
    }

    public synchronized CdaSettings getCdaSettings(String resourceLoader, String id) throws CdaSettingsReadException, AccessDeniedException {
        ICdaResourceLoader loader = this.resourceLoaders.get(resourceLoader);
        if (loader == null) {
            logger.error((Object)String.format("resource loader \"%s\" not recognized. Using default", resourceLoader));
            loader = this.defaultResourceLoader;
        }
        return this.getCdaSettings(loader, id);
    }

    private CdaSettings getCdaSettings(ICdaResourceLoader loader, String id) throws CdaSettingsReadException, AccessDeniedException {
        if (!loader.hasReadAccess(id)) {
            throw new AccessDeniedException(String.format("Current user cannot access \"%s\"", id), null);
        }
        CdaSettings cda = this.getFromCache(loader, id);
        return cda == null ? this.readCdaSettings(loader, id) : cda;
    }

    private CdaSettings getFromCache(ICdaResourceLoader loader, String id) {
        if (this.settingsCache.containsKey(id)) {
            CdaSettings cachedCda = this.settingsCache.get(id);
            if (!this.settingsTimestamps.containsKey(id)) {
                logger.error((Object)MessageFormat.format("No cache timestamp found for item {0}, cache bypassed.", id));
            } else {
                long cachedTime = this.settingsTimestamps.get(id);
                Long savedFileTime = loader.getLastModified(id);
                if (savedFileTime != null && savedFileTime <= cachedTime) {
                    return cachedCda;
                }
            }
        }
        return null;
    }

    private CdaSettings readCdaSettings(ICdaResourceLoader loader, String id) throws CdaSettingsReadException {
        try {
            ResourceManager resourceManager = this.getResourceManager();
            ResourceKey key = loader.createKey(id, null);
            Resource resource = resourceManager.create(key, null, org.w3c.dom.Document.class);
            org.w3c.dom.Document document = (org.w3c.dom.Document)resource.getResource();
            DOMReader saxReader = new DOMReader();
            Document doc = saxReader.read(document);
            CdaSettings settings = new CdaSettings(doc, id, resource.getSource());
            this.addToCache(settings);
            return settings;
        }
        catch (ResourceException re) {
            throw new CdaSettingsReadException(re.getMessage(), re);
        }
        catch (UnsupportedConnectionException e) {
            throw new CdaSettingsReadException("Unrecognized connection.", e);
        }
        catch (UnsupportedDataAccessException e) {
            throw new CdaSettingsReadException("Unrecognized data access definition.", e);
        }
    }

    public synchronized CdaSettings parseSettingsFile(String id) throws CdaSettingsReadException, AccessDeniedException {
        for (ICdaResourceLoader loader : this.resourceLoaders.values()) {
            if (!loader.isValidId(id)) continue;
            return this.getCdaSettings(loader, id);
        }
        throw new CdaSettingsReadException("No resource loader is able to handle id: " + id, null);
    }

    public ResourceManager getResourceManager() {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        resourceManager.registerLoader((ResourceLoader)this.defaultResourceLoader);
        resourceManager.registerLoader((ResourceLoader)this.resourceLoaders.get(SYSTEM_RESOURCE_LOADER_NAME));
        return resourceManager;
    }

    public ICdaResourceLoader getResourceLoader(String name) {
        return this.resourceLoaders.get(name);
    }

    private void addToCache(CdaSettings settings) {
        String id = settings.getId();
        this.settingsCache.put(id, settings);
        this.settingsTimestamps.put(id, System.currentTimeMillis());
    }

    public synchronized void clearEntryFromCache(String id) {
        if (this.settingsCache.containsKey(id)) {
            this.settingsCache.remove(id);
        }
        if (this.settingsTimestamps.containsKey(id)) {
            this.settingsTimestamps.remove(id);
        }
    }

    public synchronized void clearCache() {
        logger.info((Object)"Cleaning CDA settings cache");
        this.settingsCache.clear();
        this.settingsTimestamps.clear();
    }

    public DataAccessConnectionDescriptor[] getDataAccessDescriptors(boolean refreshCache) {
        String[] dataAccesses;
        ArrayList<DataAccessConnectionDescriptor> descriptors = new ArrayList<DataAccessConnectionDescriptor>();
        Properties components = CdaEngine.getEnvironment().getCdaComponents();
        for (String dataAccess : dataAccesses = StringUtils.split((String)StringUtils.defaultString((String)components.getProperty("dataAccesses")), (String)",")) {
            Class<?> clazz = null;
            String className = "pt.webdetails.cda.dataaccess." + dataAccess;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                logger.error((Object)MessageFormat.format("Couldn't load class {0}!", className));
                continue;
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                logger.debug((Object)(dataAccess + " is abstract: Skipping"));
                continue;
            }
            if (!AbstractDataAccess.class.isAssignableFrom(clazz)) continue;
            try {
                DataAccessConnectionDescriptor[] descriptor = DataAccessConnectionDescriptor.fromClass(clazz);
                descriptors.addAll(Arrays.asList(descriptor));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause.getClass() == UnsupportedOperationException.class) {
                    logger.warn((Object)("DataAccess " + dataAccess + " doesn't support discoverability!"));
                    continue;
                }
                logger.error((Object)("DataAccess " + dataAccess + " did something wrong!"));
            }
            catch (Exception e) {
                logger.error((Object)("DataAccess " + dataAccess + " did something wrong!"));
            }
        }
        return descriptors.toArray(new DataAccessConnectionDescriptor[descriptors.size()]);
    }
}

