/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.settings;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import javax.swing.table.TableModel;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.EvaluableConnection;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.UnsupportedConnectionException;
import pt.webdetails.cda.connections.kettle.TransFromFileConnection;
import pt.webdetails.cda.connections.metadata.MetadataConnection;
import pt.webdetails.cda.connections.mondrian.JdbcConnection;
import pt.webdetails.cda.connections.olap4j.DefaultOlap4jConnection;
import pt.webdetails.cda.connections.scripting.ScriptingConnection;
import pt.webdetails.cda.connections.sql.JndiConnection;
import pt.webdetails.cda.connections.xpath.XPathConnection;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.DataAccessEnums;
import pt.webdetails.cda.dataaccess.DenormalizedMdxDataAccess;
import pt.webdetails.cda.dataaccess.DenormalizedOlap4JDataAccess;
import pt.webdetails.cda.dataaccess.JoinCompoundDataAccess;
import pt.webdetails.cda.dataaccess.KettleDataAccess;
import pt.webdetails.cda.dataaccess.MdxDataAccess;
import pt.webdetails.cda.dataaccess.MqlDataAccess;
import pt.webdetails.cda.dataaccess.Olap4JDataAccess;
import pt.webdetails.cda.dataaccess.ReflectionDataAccess;
import pt.webdetails.cda.dataaccess.ScriptableDataAccess;
import pt.webdetails.cda.dataaccess.SqlDataAccess;
import pt.webdetails.cda.dataaccess.UnionCompoundDataAccess;
import pt.webdetails.cda.dataaccess.UnsupportedDataAccessException;
import pt.webdetails.cda.dataaccess.XPathDataAccess;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cda.utils.TableModelUtils;
import pt.webdetails.cda.utils.Util;
import pt.webdetails.cda.xml.DomTraversalHelper;
import pt.webdetails.cda.xml.XmlUtils;

public class CdaSettings {
    private static final Log logger = LogFactory.getLog(CdaSettings.class);
    private String id;
    private ResourceKey contextKey;
    private Element root;
    private HashMap<String, Connection> connectionsMap;
    private HashMap<String, DataAccess> dataAccessMap;
    private Document genDoc;

    public CdaSettings(Document doc, String id, ResourceKey key) throws UnsupportedConnectionException, UnsupportedDataAccessException {
        this.contextKey = key;
        this.id = id;
        this.root = doc.getRootElement();
        this.connectionsMap = new HashMap();
        this.dataAccessMap = new HashMap();
        this.parseDocument();
    }

    public CdaSettings(String id, ResourceKey key) {
        this.contextKey = key;
        this.id = id;
        this.genDoc = DocumentFactory.getInstance().createDocument("UTF-8");
        this.genDoc.addElement("CDADescriptor");
        this.root = this.genDoc.getRootElement();
        this.connectionsMap = new HashMap();
        this.dataAccessMap = new HashMap();
    }

    public CdaSettings(String id, ResourceKey key, boolean garbage) {
        this.contextKey = key;
        this.id = id;
        this.connectionsMap = new HashMap();
        this.dataAccessMap = new HashMap();
    }

    public TableModel listQueries() {
        return TableModelUtils.dataAccessMapToTableModel(this.dataAccessMap);
    }

    private void parseDocument() throws UnsupportedConnectionException, UnsupportedDataAccessException {
        logger.debug((Object)"Creating CdaSettings - parsing document");
        this.parseConnections();
        this.parseDataAccesses();
        logger.debug((Object)"CdaSettings created successfully");
    }

    private DataAccess parseDataAccess(Element element) {
        String typeName = element.attributeValue("type");
        DataAccessEnums.DataAccessInstanceType type = DataAccessEnums.DataAccessInstanceType.parseType(typeName);
        if (type != null) {
            switch (type) {
                case DENORMALIZED_MDX: {
                    return new DenormalizedMdxDataAccess(element);
                }
                case JOIN: {
                    return new JoinCompoundDataAccess(element);
                }
                case DENORMALIZED_OLAP4J: {
                    return new DenormalizedOlap4JDataAccess(element);
                }
                case KETTLE: {
                    return new KettleDataAccess(element);
                }
                case MDX: {
                    return new MdxDataAccess(element);
                }
                case MQL: {
                    return new MqlDataAccess(element);
                }
                case OLAP4J: {
                    return new Olap4JDataAccess(element);
                }
                case REFLECTION: {
                    return new ReflectionDataAccess(element);
                }
                case SCRIPTABLE: {
                    return new ScriptableDataAccess(element);
                }
                case SQL: {
                    return new SqlDataAccess(element);
                }
                case UNION: {
                    return new UnionCompoundDataAccess(element);
                }
                case XPATH: {
                    return new XPathDataAccess(element);
                }
            }
        }
        return null;
    }

    private void parseDataAccesses() throws UnsupportedDataAccessException {
        List dataAccessesList = this.root.selectNodes("/CDADescriptor/DataAccess | /CDADescriptor/CompoundDataAccess");
        for (Element element : dataAccessesList) {
            String type = element.attributeValue("type");
            DataAccess dataAccess = null;
            try {
                dataAccess = this.parseDataAccess(element);
                if (dataAccess != null) {
                    dataAccess.setCdaSettings(this);
                    this.addInternalDataAccess(dataAccess);
                }
            }
            catch (Exception e) {
                throw new UnsupportedDataAccessException("Error parsing DataAccess: " + Util.getExceptionDescription(e), e);
            }
            if (dataAccess != null) continue;
            throw new UnsupportedDataAccessException(MessageFormat.format("Unknown DataAccess type {0}.", type));
        }
    }

    private Connection parseConnection(String type, Element element) throws InvalidConnectionException {
        DataAccessEnums.ConnectionInstanceType connType = DataAccessEnums.ConnectionInstanceType.parseType(type);
        if (connType != null) {
            switch (connType) {
                case KETTLE_TRANS_FROM_FILE: {
                    return new TransFromFileConnection(element);
                }
                case Metadata: {
                    return new MetadataConnection(element);
                }
                case MONDRIAN_JDBC: {
                    return new JdbcConnection(element);
                }
                case MONDRIAN_JNDI: {
                    return new pt.webdetails.cda.connections.mondrian.JndiConnection(element);
                }
                case OLAP4J: {
                    return new DefaultOlap4jConnection(element);
                }
                case SCRIPTING: {
                    return new ScriptingConnection(element);
                }
                case SQL_JDBC: {
                    return new pt.webdetails.cda.connections.sql.JdbcConnection(element);
                }
                case SQL_JNDI: {
                    return new JndiConnection(element);
                }
                case XPATH: {
                    return new XPathConnection(element);
                }
            }
        }
        return null;
    }

    private void parseConnections() throws UnsupportedConnectionException {
        List connectionList = this.root.selectNodes("/CDADescriptor/DataSources/Connection");
        for (Element element : connectionList) {
            String type = element.attributeValue("type");
            Connection connection = null;
            try {
                connection = this.parseConnection(type, element);
                if (connection != null) {
                    connection.setCdaSettings(this);
                    this.addInternalConnection(connection);
                }
            }
            catch (InvalidConnectionException e) {
                throw new UnsupportedConnectionException(MessageFormat.format("Error initializing connection: {0}", Util.getExceptionDescription(e)), e);
            }
            if (connection != null) continue;
            throw new UnsupportedConnectionException(MessageFormat.format("Unrecognized connection type {0}.", type));
        }
    }

    public String asXML() throws OperationNotSupportedException, IOException, TransformerFactoryConfigurationError, TransformerException {
        if (this.genDoc == null) {
            return this.root.asXML();
        }
        DomTraversalHelper tHelper = new DomTraversalHelper();
        return XmlUtils.prettyPrint(tHelper.traverse(this).asXML());
    }

    public void addDataAccess(DataAccess dataAccess) {
        this.addInternalDataAccess(dataAccess);
        dataAccess.setCdaSettings(this);
    }

    public void addConnection(Connection connection) {
        this.addInternalConnection(connection);
        connection.setCdaSettings(this);
    }

    private void addInternalConnection(Connection connectionSettings) {
        this.connectionsMap.put(connectionSettings.getId(), connectionSettings);
    }

    private void addInternalDataAccess(DataAccess dataAccess) {
        this.dataAccessMap.put(dataAccess.getId(), dataAccess);
    }

    public Connection getConnection(String id) throws UnknownConnectionException {
        if (!this.connectionsMap.containsKey(id)) {
            throw new UnknownConnectionException("Unknown connection with id " + id, null);
        }
        Connection connection = this.connectionsMap.get(id);
        if (connection instanceof EvaluableConnection) {
            return ((EvaluableConnection)((Object)connection)).evaluate();
        }
        return connection;
    }

    public DataAccess getDataAccess(String id) throws UnknownDataAccessException {
        if (!this.dataAccessMap.containsKey(id)) {
            throw new UnknownDataAccessException("Unknown dataAccess with id " + id, null);
        }
        return this.dataAccessMap.get(id);
    }

    public String getId() {
        return this.id;
    }

    public ResourceKey getContextKey() {
        return this.contextKey;
    }

    public Map<String, Connection> getConnectionsMap() {
        return this.connectionsMap;
    }

    public Map<String, DataAccess> getDataAccessMap() {
        return this.dataAccessMap;
    }
}

