/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.settings.ICdaResourceLoader;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IACAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.MimeTypes;

public abstract class CdaFileResourceLoader
implements ICdaResourceLoader {
    private static final Log logger = LogFactory.getLog(CdaFileResourceLoader.class);
    private final String name;
    private final String schema;

    public CdaFileResourceLoader(String name) {
        assert (name != null);
        this.name = name;
        this.schema = this.getClass().getName() + ":" + name;
    }

    protected abstract IReadAccess getReader();

    protected abstract IACAccess getAccessControl();

    @Override
    public boolean hasReadAccess(String id) {
        return this.getAccessControl().hasAccess(id, FileAccess.READ);
    }

    @Override
    public long getLastModified(String id) {
        return this.getReader().getLastModified(id);
    }

    public boolean isSupportedKey(ResourceKey key) {
        return this.schema.equals(key.getSchema());
    }

    @Override
    public boolean isValidId(String id) {
        return this.getReader().fileExists(id);
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                throw new ResourceKeyCreationException("Empty key.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("creating key for " + value));
            }
            return new ResourceKey((Object)this.schema, value, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        assert (this.isSupportedKey(parent));
        if (path == null) {
            return parent;
        }
        String basePath = parent.getIdentifierAsString();
        assert (basePath != null);
        String newPath = Util.joinPath((String[])new String[]{FilenameUtils.getPath((String)basePath), path});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("deriveKey: parent='%s', path='%s' --> '%s'  ", basePath, path, newPath));
        }
        return new ResourceKey((Object)this.schema, (Object)newPath, factoryKeys);
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        assert (key.getSchema().equals(this.schema));
        return new CdaResourceData(this.name, key, this.getReader(), key.getIdentifierAsString());
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public boolean isSupportedDeserializer(String data) {
        return this.schema.equals(ResourceKeyUtils.readSchemaFromString((String)data));
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return ResourceKeyUtils.createStringResourceKey((String)key.getSchema().toString(), (String)key.getIdentifierAsString(), (Map)key.getFactoryParameters());
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse((String)stringKey);
        if (!this.schema.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Wrong schema");
        }
        return new ResourceKey((Object)this.schema, (Object)keyData.getIdentifier(), keyData.getFactoryParameters());
    }

    public String toString() {
        return this.schema;
    }

    protected static class CdaResourceData
    extends AbstractResourceData
    implements ResourceData {
        private static final long serialVersionUID = 1L;
        private static final long NO_VERSION = -1L;
        private ResourceKey key;
        private byte[] contents;
        private String fileName;
        private String mimeType;
        private String path;
        private String resourceLoaderName;

        public CdaResourceData(String resourceLoader, ResourceKey key, IReadAccess reader, String path) throws ResourceLoadingException {
            this.key = key;
            this.path = path;
            IBasicFile file = reader.fetchFile(path);
            if (file == null) {
                String msg = String.format("Unable to fetch '%s'.", path);
                logger.error((Object)msg);
                throw new ResourceLoadingException(msg);
            }
            try {
                this.contents = IOUtils.toByteArray((InputStream)file.getContents());
            }
            catch (IOException e) {
                throw new ResourceLoadingException(e.getLocalizedMessage(), (Exception)e);
            }
            this.mimeType = MimeTypes.getMimeTypeFromExt((String)file.getExtension());
            this.fileName = file.getName();
            this.resourceLoaderName = resourceLoader;
        }

        public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
            return new ByteArrayInputStream(this.contents);
        }

        public Object getAttribute(String key) {
            if (StringUtils.isEmpty((String)key)) {
                return null;
            }
            if (key.equals("filename")) {
                return this.fileName;
            }
            if (key.equals("content-type")) {
                return this.mimeType;
            }
            return null;
        }

        public ResourceKey getKey() {
            return this.key;
        }

        public long getVersion(ResourceManager caller) throws ResourceLoadingException {
            ICdaResourceLoader loader = CdaEngine.getInstance().getSettingsManager().getResourceLoader(this.resourceLoaderName);
            long version = loader != null ? loader.getLastModified(this.path) : -1L;
            return version == 0L ? -1L : version;
        }
    }
}

