/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.exporter.BinaryExporter;
import pt.webdetails.cda.exporter.CsvExporter;
import pt.webdetails.cda.exporter.HtmlExporter;
import pt.webdetails.cda.exporter.JsonExporter;
import pt.webdetails.cda.exporter.TableExporter;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.exporter.XlsExporter;
import pt.webdetails.cda.exporter.XmlExporter;
import pt.webdetails.cda.utils.Util;

public class ExporterEngine {
    private static final Log logger = LogFactory.getLog(ExporterEngine.class);

    public TableExporter getExporter(String outputType) throws UnsupportedExporterException {
        return this.getExporter(outputType, null);
    }

    public TableExporter getExporter(String outputType, Map<String, String> extraSettings) throws UnsupportedExporterException {
        TableExporter exporter = this.getExporter(OutputType.parse(outputType), extraSettings);
        if (exporter != null) {
            return exporter;
        }
        logger.error((Object)MessageFormat.format("getExporter for {0} failed, falling back to old version", outputType));
        try {
            String className = "pt.webdetails.cda.exporter." + outputType.substring(0, 1).toUpperCase() + outputType.substring(1, outputType.length()) + "Exporter";
            Class<?> clazz = Class.forName(className);
            Class[] params = new Class[]{HashMap.class};
            exporter = (TableExporter)clazz.getConstructor(params).newInstance(extraSettings);
            return exporter;
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedExporterException("Could not find exporter for " + outputType, e);
        }
        catch (Exception e) {
            throw new UnsupportedExporterException("Error initializing export class: " + Util.getExceptionDescription(e), e);
        }
    }

    private TableExporter getExporter(OutputType type, Map<String, String> extraSettings) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case CSV: {
                return new CsvExporter(extraSettings);
            }
            case HTML: {
                return new HtmlExporter(extraSettings);
            }
            case JSON: {
                return new JsonExporter(extraSettings);
            }
            case XLS: {
                return new XlsExporter(extraSettings);
            }
            case XML: {
                return new XmlExporter(extraSettings);
            }
            case BINARY: {
                return new BinaryExporter(extraSettings);
            }
        }
        return null;
    }

    public static enum OutputType {
        JSON("json"),
        XML("xml"),
        CSV("csv"),
        XLS("xls"),
        HTML("html"),
        BINARY("binary");

        private String type;

        private OutputType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static OutputType parse(String typeStr) {
            for (OutputType outputType : OutputType.values()) {
                if (!StringUtils.equalsIgnoreCase((String)outputType.toString(), (String)typeStr)) continue;
                return outputType;
            }
            return null;
        }
    }
}

