/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.exporter.AbstractExporter;
import pt.webdetails.cda.exporter.Exporter;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.utils.kettle.RowCountListener;
import pt.webdetails.robochef.DynamicTransConfig;
import pt.webdetails.robochef.DynamicTransMetaConfig;
import pt.webdetails.robochef.DynamicTransformation;
import pt.webdetails.robochef.RowProductionManager;
import pt.webdetails.robochef.TableModelInput;

public abstract class AbstractKettleExporter
extends AbstractExporter
implements Exporter,
RowProductionManager {
    private static final Log logger = LogFactory.getLog(AbstractKettleExporter.class);
    public static final String COLUMN_HEADERS_SETTING = "columnHeaders";
    public static final String FILE_EXTENSION_SETTING = "fileExtension";
    protected ExecutorService executorService = Executors.newCachedThreadPool();
    protected Collection<Callable<Boolean>> inputCallables = new ArrayList<Callable<Boolean>>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
    private String filename;
    private static long DEFAULT_ROW_PRODUCTION_TIMEOUT = 120L;
    private static TimeUnit DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT = TimeUnit.SECONDS;

    protected AbstractKettleExporter(Map<String, String> extraSettings) {
        super(extraSettings);
    }

    protected abstract StepMeta getExportStepMeta(String var1);

    protected abstract String getType();

    @Override
    public void startRowProduction() {
        String timeoutStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeout");
        long timeout = StringUtil.isEmpty((String)timeoutStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT : Long.parseLong(timeoutStr);
        String unitStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeoutTimeUnit");
        TimeUnit unit = StringUtil.isEmpty((String)unitStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT : TimeUnit.valueOf(unitStr);
        this.startRowProduction(timeout, unit);
    }

    @Override
    public void startRowProduction(long timeout, TimeUnit unit) {
        try {
            List<Future<Boolean>> results = this.executorService.invokeAll(this.inputCallables, timeout, unit);
            for (Future<Boolean> result : results) {
                result.get();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void export(OutputStream out, TableModel tableModel) throws ExporterException {
        this.inputCallables.clear();
        try {
            DynamicTransMetaConfig transMetaConfig = new DynamicTransMetaConfig(DynamicTransMetaConfig.Type.EMPTY, "Exporter", null, null);
            DynamicTransConfig transConfig = new DynamicTransConfig();
            StepMeta injectorStepMeta = new StepMeta("input", (StepMetaInterface)new InjectorMeta());
            injectorStepMeta.setCopies(1);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, injectorStepMeta.getName(), injectorStepMeta.getXML());
            StepMeta exportStepMeta = this.getExportStepMeta("export");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, exportStepMeta.getName(), exportStepMeta.getXML());
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, injectorStepMeta.getName(), exportStepMeta.getName());
            TableModelInput input = new TableModelInput();
            transConfig.addInput(injectorStepMeta.getName(), input);
            this.inputCallables.add(input.getCallableRowProducer(tableModel, true));
            RowCountListener countListener = new RowCountListener();
            transConfig.addOutput(exportStepMeta.getName(), countListener);
            DynamicTransformation trans = new DynamicTransformation(transConfig, transMetaConfig);
            trans.executeCheckedSuccess(null, null, this);
            logger.info((Object)trans.getReadWriteThroughput());
            this.copyFileToOutputStream(out);
            logger.debug((Object)(countListener.getRowsWritten() + " rows written."));
        }
        catch (KettleException e) {
            throw new ExporterException("Kettle exception during " + this.getType() + " query ", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ExporterException("Unknown exception during " + this.getType() + " query ", e);
        }
    }

    protected String getFileName() {
        this.filename = "pentaho-cda-" + this.getType() + "-" + this.dateFormat.format(Calendar.getInstance().getTime()) + "-" + UUID.randomUUID().toString();
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileToOutputStream(OutputStream os) throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + this.filename + "." + this.getType());
        FileInputStream is = new FileInputStream(file);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            os.flush();
            IOUtils.closeQuietly((InputStream)is);
        }
        file.delete();
    }
}

