/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.OutputStream;
import java.sql.Blob;
import java.util.Date;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.TableExporter;

public abstract class AbstractExporter
implements TableExporter {
    public static final String ATTACHMENT_NAME_SETTING = "attachmentName";
    protected static final Log logger = LogFactory.getLog(AbstractExporter.class);
    protected Map<String, String> extraSettings;

    public AbstractExporter() {
    }

    public AbstractExporter(Map<String, String> extraSettings) {
        this.extraSettings = extraSettings;
    }

    @Override
    public abstract void export(OutputStream var1, TableModel var2) throws ExporterException;

    @Override
    public abstract String getMimeType();

    protected String getColType(Class<?> columnClass) throws ExporterException {
        if (columnClass.equals(String.class)) {
            return "String";
        }
        if (columnClass.equals(Boolean.class)) {
            return "Boolean";
        }
        if (columnClass.equals(Integer.class) || columnClass.equals(Short.class) || columnClass.equals(Byte.class)) {
            return "Integer";
        }
        if (Number.class.isAssignableFrom(columnClass)) {
            return "Numeric";
        }
        if (Date.class.isAssignableFrom(columnClass)) {
            return "Date";
        }
        if (columnClass.equals(Object.class)) {
            return "String";
        }
        if (columnClass.equals(byte[].class) || Blob.class.isAssignableFrom(columnClass)) {
            return "Blob";
        }
        logger.warn((Object)("CDA exporter doesn't know how to handle:" + columnClass.toString() + "; Returning String to allow it to continue"));
        return "String";
    }

    protected String getSetting(String name, String defaultValue) {
        return this.extraSettings == null ? defaultValue : this.getSetting(this.extraSettings, name, defaultValue);
    }

    protected String getSetting(Map<String, String> settings, String name, String defaultValue) {
        if (settings.containsKey(name)) {
            return settings.get(name);
        }
        return defaultValue;
    }
}

