/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.dom4j.Element;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.dataaccess.CompoundDataAccess;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cda.utils.TableModelUtils;

public class UnionCompoundDataAccess
extends CompoundDataAccess {
    private static final String TYPE = "union";
    private String topId;
    private String bottomId;

    public UnionCompoundDataAccess() {
    }

    public UnionCompoundDataAccess(Element element) {
        super(element);
        Element top = (Element)element.selectSingleNode("Top");
        Element bottom = (Element)element.selectSingleNode("Bottom");
        this.topId = top.attributeValue("id");
        this.bottomId = bottom.attributeValue("id");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TableModel queryDataSource(QueryOptions queryOptions) throws QueryException {
        try {
            QueryOptions croppedOptions = (QueryOptions)queryOptions.clone();
            croppedOptions.setSortBy(new ArrayList<String>());
            croppedOptions.setPageSize(0);
            croppedOptions.setPageStart(0);
            TableModel tableModelA = this.getCdaSettings().getDataAccess(this.topId).doQuery(croppedOptions);
            TableModel tableModelB = this.getCdaSettings().getDataAccess(this.bottomId).doQuery(croppedOptions);
            return TableModelUtils.appendTableModel(tableModelA, tableModelB);
        }
        catch (CloneNotSupportedException e) {
            throw new QueryException("Couldn't clone settings ", e);
        }
        catch (UnknownDataAccessException e) {
            throw new QueryException("Unknown Data access in CompoundDataAccess ", e);
        }
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.NONE;
    }

    @Override
    public ArrayList<PropertyDescriptor> getInterface() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("top", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("bottom", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("parameters", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    public String getTopId() {
        return this.topId;
    }

    public String getBottomId() {
        return this.bottomId;
    }

    @Override
    public void setQuery(String query) {
    }
}

