/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.lang.reflect.Method;
import java.util.List;
import javax.swing.table.TableModel;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.SimpleDataAccess;
import pt.webdetails.cda.settings.UnknownConnectionException;

public abstract class PREDataAccess
extends SimpleDataAccess {
    public PREDataAccess() {
    }

    public PREDataAccess(Element element) {
        super(element);
    }

    public PREDataAccess(String id, String name, String connectionId, String query) {
        super(id, name, connectionId, query);
    }

    public abstract DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SimpleDataAccess.IDataSourceQuery performRawQuery(ParameterDataRow parameterDataRow) throws QueryException {
        try {
            CachingDataFactory dataFactory = new CachingDataFactory(this.getDataFactory(), false);
            Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
            this.initializeDataFactory((DataFactory)dataFactory, configuration);
            IDataAccessUtils dataAccessUtils = CdaEngine.getEnvironment().getDataAccessUtils();
            ReportEnvironmentDataRow environmentDataRow = dataAccessUtils.createEnvironmentDataRow(configuration);
            PREDataSourceQuery queryExecution = null;
            try {
                TableModel tm = dataFactory.queryData("query", (DataRow)new CompoundDataRow((DataRow)environmentDataRow, (DataRow)parameterDataRow));
                queryExecution = new PREDataSourceQuery(tm, dataFactory);
            }
            finally {
                if (queryExecution == null) {
                    dataFactory.close();
                }
            }
            return queryExecution;
        }
        catch (UnknownConnectionException e) {
            throw new QueryException("Unknown connection", e);
        }
        catch (InvalidConnectionException e) {
            throw new QueryException("Unknown connection", e);
        }
        catch (ReportDataFactoryException e) {
            Method[] allMethods;
            Throwable lastKnownParent = null;
            boolean oldPrd = false;
            for (Method m : allMethods = ReportDataFactoryException.class.getMethods()) {
                if (!m.getName().equals("getParentThrowable")) continue;
                try {
                    lastKnownParent = (Throwable)m.invoke((Object)e, new Object[0]);
                    oldPrd = true;
                }
                catch (Exception e1) {
                }
                catch (Error e1) {}
                break;
            }
            if (!oldPrd || lastKnownParent == null) {
                lastKnownParent = e.getCause();
            }
            if (lastKnownParent != null) {
                throw new QueryException(lastKnownParent.getMessage(), lastKnownParent);
            }
            throw new QueryException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void initializeDataFactory(DataFactory dataFactory, Configuration configuration) throws ReportDataFactoryException {
        ResourceManager resourceManager = CdaEngine.getInstance().getSettingsManager().getResourceManager();
        ResourceKey contextKey = this.getCdaSettings().getContextKey();
        CdaEngine.getEnvironment().initializeDataFactory(dataFactory, configuration, contextKey, resourceManager);
    }

    @Override
    public List<PropertyDescriptor> getInterface() {
        List<PropertyDescriptor> properties = super.getInterface();
        return properties;
    }

    protected static class PREDataSourceQuery
    implements SimpleDataAccess.IDataSourceQuery {
        private TableModel tableModel;
        private CachingDataFactory localDataFactory;

        public PREDataSourceQuery(TableModel tm, CachingDataFactory df) {
            this.tableModel = tm;
            this.localDataFactory = df;
        }

        @Override
        public TableModel getTableModel() {
            return this.tableModel;
        }

        @Override
        public void closeDataSource() throws QueryException {
            if (this.localDataFactory == null) {
                return;
            }
            if (this.getTableModel() instanceof CloseableTableModel) {
                CloseableTableModel ctm = (CloseableTableModel)this.getTableModel();
                ctm.close();
            }
            this.localDataFactory.close();
            this.localDataFactory = null;
        }
    }
}

