/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import pt.webdetails.cda.connections.mondrian.MondrianConnectionInfo;

public class JdbcConnectionInfo
implements MondrianConnectionInfo {
    private String driver;
    private String url;
    private String user;
    private String pass;
    private String catalog;
    private String cube;
    private Properties properties;
    private String roleField;
    private String userField;
    private String passwordField;
    private String mondrianRole;

    public JdbcConnectionInfo(Element connection) {
        String driver = (String)connection.selectObject("string(./Driver)");
        String url = (String)connection.selectObject("string(./Url)");
        String userName = (String)connection.selectObject("string(./User)");
        String password = (String)connection.selectObject("string(./Pass)");
        String role = (String)connection.selectObject("string(./Role)");
        String roleFormula = (String)connection.selectObject("string(./RoleField)");
        String userFormula = (String)connection.selectObject("string(./UserField)");
        String passFormula = (String)connection.selectObject("string(./PassField)");
        if (StringUtils.isEmpty((String)driver)) {
            throw new IllegalStateException("A driver is mandatory");
        }
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalStateException("A url is mandatory");
        }
        this.setDriver(driver);
        this.setUrl(url);
        if (userName != null) {
            this.setUser(userName);
        }
        if (password != null) {
            this.setPass(password);
        }
        if (!StringUtils.isEmpty((String)role)) {
            this.setMondrianRole(role);
        }
        if (!StringUtils.isEmpty((String)userFormula)) {
            this.setUserField(userFormula);
        }
        if (!StringUtils.isEmpty((String)passFormula)) {
            this.setPasswordField(passFormula);
        }
        if (!StringUtils.isEmpty((String)roleFormula)) {
            this.setRoleField(roleFormula);
        }
        this.properties = new Properties();
        List list = connection.elements("Property");
        for (Element childElement : list) {
            String name = childElement.attributeValue("name");
            String text = childElement.getText();
            this.properties.put(name, text);
        }
        this.setCatalog((String)connection.selectObject("string(./Catalog)"));
        this.setCube((String)connection.selectObject("string(./Cube)"));
    }

    public void setMondrianRole(String mondrianRole) {
        this.mondrianRole = mondrianRole;
    }

    @Override
    public String getMondrianRole() {
        return this.mondrianRole;
    }

    @Override
    public String getRoleField() {
        return this.roleField;
    }

    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    @Override
    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    @Override
    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcConnectionInfo)) {
            return false;
        }
        JdbcConnectionInfo that = (JdbcConnectionInfo)o;
        if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) {
            return false;
        }
        if (this.cube != null ? !this.cube.equals(that.cube) : that.cube != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.pass != null ? !this.pass.equals(that.pass) : that.pass != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.driver != null ? this.driver.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.pass != null ? this.pass.hashCode() : 0);
        result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
        result = 31 * result + (this.cube != null ? this.cube.hashCode() : 0);
        return result;
    }
}

