/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.kettle;

import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;

public class TransFromFileConnectionInfo {
    private String transformationFile;
    private String[] definedArgumentNames;
    private ParameterMapping[] definedVariableNames;

    public TransFromFileConnectionInfo(Element connection) {
        this.transformationFile = (String)connection.selectObject("string(./KtrFile)");
        List argsList = connection.elements("arguments");
        String[] args = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            Element element = (Element)argsList.get(i);
            args[i] = element.getText();
        }
        this.definedArgumentNames = args;
        List varsList = connection.elements("variables");
        ParameterMapping[] vars = new ParameterMapping[varsList.size()];
        for (int i = 0; i < varsList.size(); ++i) {
            Element element = (Element)varsList.get(i);
            String dataRowName = element.attributeValue("datarow-name");
            String variableName = element.attributeValue("variable-name");
            vars[i] = variableName == null ? new ParameterMapping(dataRowName, dataRowName) : new ParameterMapping(dataRowName, variableName);
        }
        this.definedVariableNames = vars;
    }

    public String getTransformationFile() {
        return this.transformationFile;
    }

    public String[] getDefinedArgumentNames() {
        return this.definedArgumentNames;
    }

    public ParameterMapping[] getDefinedVariableNames() {
        return this.definedVariableNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransFromFileConnectionInfo that = (TransFromFileConnectionInfo)o;
        if (!Arrays.equals(this.definedArgumentNames, that.definedArgumentNames)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.parameterMappingToStringArray(this.definedVariableNames), (Object[])this.parameterMappingToStringArray(that.definedVariableNames))) {
            return false;
        }
        return !(this.transformationFile != null ? !this.transformationFile.equals(that.transformationFile) : that.transformationFile != null);
    }

    public int hashCode() {
        int result = this.transformationFile != null ? this.transformationFile.hashCode() : 0;
        result = 31 * result + (this.definedArgumentNames != null ? Arrays.hashCode(this.definedArgumentNames) : 0);
        result = 31 * result + (this.definedVariableNames != null ? Arrays.deepHashCode((Object[])this.parameterMappingToStringArray(this.definedVariableNames)) : 0);
        return result;
    }

    private String[][] parameterMappingToStringArray(ParameterMapping[] paramMaps) {
        if (paramMaps == null) {
            return null;
        }
        String[][] result = new String[paramMaps.length][];
        for (int i = 0; i < paramMaps.length; ++i) {
            String[] item = new String[]{paramMaps[i].getName(), paramMaps[i].getAlias()};
            result[i] = item;
        }
        return result;
    }
}

