/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.kettle;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.kettle.KettleConnection;
import pt.webdetails.cda.connections.kettle.TransFromFileConnectionInfo;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.settings.CdaSettings;

public class TransFromFileConnection
extends AbstractConnection
implements KettleConnection {
    private TransFromFileConnectionInfo connectionInfo;

    public TransFromFileConnection() {
    }

    public TransFromFileConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    @Override
    public KettleTransformationProducer createTransformationProducer(String query, CdaSettings cdaSettings) {
        IDataAccessUtils dataAccessUtils = CdaEngine.getEnvironment().getDataAccessUtils();
        return dataAccessUtils.createKettleTransformationProducer(this.connectionInfo, query, cdaSettings);
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.KETTLE;
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new TransFromFileConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return "kettleTransFromFile";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransFromFileConnection that = (TransFromFileConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }

    public ArrayList<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("ktrFile", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("variables", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getTypeForFile() {
        return "kettle.TransFromFile";
    }

    public TransFromFileConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

