/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections;

import org.dom4j.Element;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import pt.webdetails.cda.utils.FormulaEvaluator;

public class JndiConnectionInfo {
    private String jndi = "";
    private String user;
    private String pass;
    private String userField;
    private String passwordField;

    public JndiConnectionInfo(Element connection) {
        this.jndi = (String)connection.selectObject("string(./Jndi)");
        String userName = (String)connection.selectObject("string(./User)");
        String password = (String)connection.selectObject("string(./Pass)");
        String userFormula = (String)connection.selectObject("string(./UserField)");
        String passFormula = (String)connection.selectObject("string(./PassField)");
        if (!StringUtils.isEmpty((String)userName)) {
            this.setUser(userName);
        }
        if (!StringUtils.isEmpty((String)password)) {
            this.setPass(password);
        }
        if (!StringUtils.isEmpty((String)userFormula)) {
            this.setUserField(userFormula);
        }
        if (!StringUtils.isEmpty((String)passFormula)) {
            this.setPasswordField(passFormula);
        }
    }

    public JndiConnectionInfo(String jndi, String userName, String password, String userFormula, String passFormula) {
        this.jndi = jndi;
        if (!StringUtils.isEmpty((String)userName)) {
            this.setUser(userName);
        }
        if (!StringUtils.isEmpty((String)password)) {
            this.setPass(password);
        }
        if (!StringUtils.isEmpty((String)userFormula)) {
            this.setUserField(userFormula);
        }
        if (!StringUtils.isEmpty((String)passFormula)) {
            this.setPasswordField(passFormula);
        }
    }

    public String getUser() {
        return FormulaEvaluator.replaceFormula(this.user);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public String getJndi() {
        return this.jndi == null ? "" : this.jndi;
    }

    public void setJndi(String jndi) {
        this.jndi = jndi == null ? "" : jndi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiConnectionInfo that = (JndiConnectionInfo)o;
        return StringUtils.equals((String)this.jndi, (String)that.jndi);
    }

    public int hashCode() {
        return this.getJndi().hashCode();
    }
}

