/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections;

import java.util.List;
import org.dom4j.Element;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.xml.DomVisitor;

public abstract class AbstractConnection
implements Connection {
    private String id;
    private CdaSettings cdaSettings;
    protected static ConnectionCatalog.ConnectionType connectionType;

    public AbstractConnection() {
    }

    public AbstractConnection(String id) {
        this.id = id;
    }

    public AbstractConnection(Element connection) throws InvalidConnectionException {
        this.id = connection.attributeValue("id");
        this.initializeConnection(connection);
    }

    @Override
    public abstract ConnectionCatalog.ConnectionType getGenericType();

    protected abstract void initializeConnection(Element var1) throws InvalidConnectionException;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public abstract String getType();

    @Override
    public CdaSettings getCdaSettings() {
        return this.cdaSettings;
    }

    @Override
    public void setCdaSettings(CdaSettings cdaSettings) {
        this.cdaSettings = cdaSettings;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public List<PropertyDescriptor> getProperties() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public String getTypeForFile() {
        return this.getClass().toString().toLowerCase().replaceAll("class pt.webdetails.cda.connections.(.*)connection", "$1");
    }

    @Override
    public void accept(DomVisitor v, Element ele) {
        v.visit(this, ele);
    }
}

