/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.table.TableModel;
import mondrian.olap.InvalidArgumentException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.cache.TableCacheKey;
import pt.webdetails.cda.cache.monitor.CacheElementInfo;
import pt.webdetails.cda.cache.monitor.ExtraCacheInfo;

public class EHCacheQueryCache
implements IQueryCache {
    private static final Log logger = LogFactory.getLog(EHCacheQueryCache.class);
    private static final String CACHE_NAME = "pentaho-cda-dataaccess";
    private static final String CACHE_CFG_FILE = "ehcache-cda.xml";
    private static final String CACHE_CFG_FILE_DIST = "ehcache-dist.xml";
    private static final String USE_TERRACOTTA_PROPERTY = "pt.webdetails.cda.UseTerracotta";
    private static CacheManager cacheManager;
    Cache cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized Cache getCacheFromManager(boolean switchClassLoader) throws CacheException {
        block11: {
            if (cacheManager != null) break block11;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                boolean useTerracotta;
                if (switchClassLoader) {
                    Thread.currentThread().setContextClassLoader(EHCacheQueryCache.class.getClassLoader());
                }
                String configFilePath = (useTerracotta = Boolean.parseBoolean(CdaEngine.getInstance().getConfigProperty(USE_TERRACOTTA_PROPERTY))) ? CACHE_CFG_FILE_DIST : CACHE_CFG_FILE;
                InputStream configFile = null;
                try {
                    configFile = CdaEngine.getRepo().getPluginSystemReader("").getFileInputStream(configFilePath);
                    cacheManager = new CacheManager(configFile);
                    logger.debug((Object)("Cache started using " + configFilePath));
                }
                catch (IOException ioe) {
                    try {
                        logger.error((Object)("Error reading " + configFilePath));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(configFile);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)configFile);
                }
                IOUtils.closeQuietly((InputStream)configFile);
                if (!useTerracotta) {
                    EHCacheQueryCache.enableCacheProperShutdown(true);
                }
            }
            finally {
                if (switchClassLoader) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        }
        if (!cacheManager.cacheExists(CACHE_NAME)) {
            cacheManager.addCache(CACHE_NAME);
        }
        return cacheManager.getCache(CACHE_NAME);
    }

    private static void enableCacheProperShutdown(boolean force) {
        if (!force) {
            try {
                System.getProperty("net.sf.ehcache.enableShutdownHook");
                return;
            }
            catch (NullPointerException npe) {
            }
            catch (InvalidArgumentException iae) {
            }
            catch (SecurityException se) {
                return;
            }
        }
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
    }

    public EHCacheQueryCache(Cache cache) {
        this.cache = cache;
    }

    public EHCacheQueryCache() {
        this(EHCacheQueryCache.getCacheFromManager(true));
    }

    public EHCacheQueryCache(boolean switchClassLoader) {
        this(EHCacheQueryCache.getCacheFromManager(switchClassLoader));
    }

    @Override
    public void putTableModel(TableCacheKey key, TableModel table, int ttlSec, ExtraCacheInfo info) {
        CacheElement cacheElement = new CacheElement(table, info);
        Element storeElement = new Element((Serializable)key, (Serializable)cacheElement);
        storeElement.setTimeToLive(ttlSec);
        this.cache.put(storeElement);
        this.cache.flush();
        logger.debug((Object)("Cache status: " + this.cache.getMemoryStoreSize() + " in memory, " + this.cache.getDiskStoreSize() + " in disk"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableModel getTableModel(TableCacheKey key) {
        TableModel tableModel;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            TableModel cachedTableModel;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Element element = this.cache.get((Serializable)key);
            if (element != null && (cachedTableModel = ((CacheElement)element.getObjectValue()).getTable()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found tableModel in cache. Returning");
                    logger.debug((Object)("Cache status: " + this.cache.getMemoryStoreSize() + " in memory, " + this.cache.getDiskStoreSize() + " in disk"));
                }
                TableModel tableModel2 = cachedTableModel;
                return tableModel2;
            }
            tableModel = null;
            return tableModel;
        }
        catch (Exception e) {
            logger.error((Object)("Error while attempting to load from cache, bypassing cache (cause: " + e.getClass() + ")"), (Throwable)e);
            tableModel = null;
            return tableModel;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    @Override
    public void clearCache() {
        this.cache.removeAll();
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public boolean remove(TableCacheKey key) {
        return this.cache.remove((Serializable)key);
    }

    @Override
    public Iterable<TableCacheKey> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public ExtraCacheInfo getCacheEntryInfo(TableCacheKey key) {
        Element element = this.cache.getQuiet((Serializable)key);
        if (element == null) {
            logger.warn((Object)"Null element in cache, removing.");
            this.remove(key);
            return null;
        }
        Serializable val = element.getValue();
        if (val instanceof CacheElement) {
            return ((CacheElement)val).getInfo();
        }
        logger.error((Object)("Expected " + CacheElement.class.getCanonicalName() + ", found " + val.getClass().getCanonicalName() + " instead"));
        this.remove(key);
        return null;
    }

    @Override
    public CacheElementInfo getElementInfo(TableCacheKey key) {
        Element element = this.cache.getQuiet((Serializable)key);
        CacheElementInfo info = new CacheElementInfo();
        info.setKey(key);
        if (element != null) {
            info.setInsertTime(element.getLatestOfCreationAndUpdateTime());
            info.setAccessTime(element.getLastAccessTime());
            info.setHits(element.getHitCount());
            Serializable val = element.getValue();
            if (val instanceof CacheElement) {
                info.setRows(((CacheElement)val).getTable().getRowCount());
            }
        }
        return info;
    }

    @Override
    public int removeAll(String cdaSettingsId, String dataAccessId) {
        int deleteCount = 0;
        if (cdaSettingsId == null) {
            deleteCount = this.cache.getSize();
            this.clearCache();
        }
        for (TableCacheKey key : this.getKeys()) {
            ExtraCacheInfo info = ((CacheElement)this.cache.getQuiet((Serializable)key).getObjectValue()).getInfo();
            if (!StringUtils.equals((String)cdaSettingsId, (String)info.getCdaSettingsId()) || dataAccessId != null && !StringUtils.equals((String)dataAccessId, (String)info.getDataAccessId()) || !this.remove(key)) continue;
            ++deleteCount;
        }
        return deleteCount;
    }

    @Override
    public void shutdownIfRunning() {
        if (cacheManager != null) {
            if (this.cache != null) {
                this.cache.flush();
            }
            if (cacheManager.getStatus() == Status.STATUS_ALIVE) {
                logger.debug((Object)"Shutting down cache manager.");
                cacheManager.shutdown();
                cacheManager = null;
            }
        }
    }

    private static class CacheElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private TableModel table;
        private ExtraCacheInfo info;

        public CacheElement(TableModel table, ExtraCacheInfo info) {
            this.table = table;
            this.info = info;
        }

        public TableModel getTable() {
            return this.table;
        }

        public ExtraCacheInfo getInfo() {
            return this.info;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.table);
            out.writeObject(this.info);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.table = (TableModel)in.readObject();
            this.info = (ExtraCacheInfo)in.readObject();
        }
    }
}

