/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.utils.FormulaEvaluator;

public class DataAccessCacheElementParser {
    public static final boolean DEFAULT_CACHE_ENABLED = true;
    private boolean cacheEnabled = true;
    private static final Log logger = LogFactory.getLog(DataAccessCacheElementParser.class);
    private static final String ATTR_CACHE_ENABLED = "enabled";
    private static final String ATTR_DURATION = "duration";
    private static final String ATTR_KEY_NAME = "name";
    private static final String ATTR_KEY_VALUE = "value";
    private static final String ATTR_KEY_DEFAULT_VALUE = "default";
    private Integer cacheDuration;
    private CacheKey cacheKey;
    private Element element;

    public DataAccessCacheElementParser(Element element) {
        this.element = element;
        this.cacheEnabled = true;
    }

    public boolean parseParameters() {
        boolean success = false;
        try {
            if (this.contains(this.element, ATTR_CACHE_ENABLED) && this.element.attributeValue(ATTR_CACHE_ENABLED).toString().equalsIgnoreCase("false")) {
                this.setCacheEnabled(false);
            }
            if (this.contains(this.element, ATTR_DURATION) && this.isValidPositiveInteger(this.element.attributeValue(ATTR_DURATION).toString())) {
                this.setCacheDuration(Integer.parseInt(this.element.attributeValue(ATTR_DURATION).toString()));
            }
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean parseKeys() {
        boolean success = false;
        try {
            this.cacheKey = new CacheKey();
            List keyNodes = this.element.selectNodes("Key");
            if (keyNodes != null) {
                for (Element keyNode : keyNodes) {
                    this.buildKeyValuePair(keyNode);
                }
            }
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    private void buildKeyValuePair(Element keyNode) {
        if (keyNode != null && this.contains(keyNode, ATTR_KEY_NAME) && this.contains(keyNode, ATTR_KEY_VALUE)) {
            String key = keyNode.attributeValue(ATTR_KEY_NAME).toString();
            String value = FormulaEvaluator.replaceFormula(keyNode.attributeValue(ATTR_KEY_VALUE).toString());
            if (StringUtils.isEmpty((String)value) || value.trim().equals("null") && keyNode.attributeValue(ATTR_KEY_DEFAULT_VALUE) != null) {
                value = keyNode.attributeValue(ATTR_KEY_DEFAULT_VALUE).toString();
            }
            this.cacheKey.addKeyValuePair(key, value);
        }
    }

    private boolean contains(Element elem, String attr) {
        return elem != null && !StringUtils.isEmpty((String)elem.attributeValue(attr));
    }

    private boolean isValidPositiveInteger(String value) {
        try {
            return Integer.parseInt(value) > -1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public Integer getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Integer cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }
}

