/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.AccessDeniedException;
import pt.webdetails.cda.CdaBoot;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.CdaSettingsReadException;
import pt.webdetails.cda.settings.SettingsManager;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cda.utils.Util;

public class CdaExecutor {
    private static final Log logger = LogFactory.getLog(CdaExecutor.class);
    private static CdaExecutor _instance;

    protected CdaExecutor() {
        logger.debug((Object)"Initializing CdaExecutor");
    }

    public static void main(String[] args) {
        CdaExecutor cdaExecutor = CdaExecutor.getInstance();
        cdaExecutor.doQuery();
    }

    private void doQuery() {
        try {
            CdaBoot.getInstance().start();
            PrintStream out = System.out;
            this.testBlocks(out);
        }
        catch (ExporterException e) {
            logger.fatal((Object)("ExporterException " + Util.getExceptionDescription(e)));
        }
        catch (AccessDeniedException e) {
            logger.error((Object)("Access denied " + Util.getExceptionDescription(e)));
        }
        catch (Exception e) {
            logger.fatal((Object)(e.getLocalizedMessage() + ": " + Util.getExceptionDescription(e)));
        }
    }

    private void testBlocks(OutputStream out) throws CdaSettingsReadException, UnknownDataAccessException, QueryException, UnsupportedExporterException, ExporterException, AccessDeniedException {
        logger.info((Object)"Testing CDA file interaction through blocks");
        SettingsManager settingsManager = CdaEngine.getInstance().getSettingsManager();
        File settingsFile = new File("samples/sample-gen.cda");
        CdaSettings cdaSettings = settingsManager.parseSettingsFile(settingsFile.getAbsolutePath());
        this.testSingleSqlQuery(out, cdaSettings);
    }

    private void testSingleSqlQuery(OutputStream out, CdaSettings cdaSettings) throws UnknownDataAccessException, QueryException, UnsupportedExporterException, ExporterException {
        logger.debug((Object)"Doing query on Cda - Initializing CdaEngine");
        CdaEngine engine = CdaEngine.getInstance();
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataAccessId("1");
        queryOptions.addParameter("orderDate", "2003-04-01");
        queryOptions.setOutputType("csv");
        engine.doExportQuery(cdaSettings, queryOptions).writeOut(out);
    }

    public static synchronized CdaExecutor getInstance() {
        if (_instance == null) {
            _instance = new CdaExecutor();
        }
        return _instance;
    }
}

