/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import pt.webdetails.cda.CoreBeanFactory;
import pt.webdetails.cda.ICdaBeanFactory;
import pt.webdetails.cda.ICdaEnvironment;
import pt.webdetails.cda.InitializationException;
import pt.webdetails.cda.cache.EHCacheQueryCache;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.connections.mondrian.IMondrianRoleMapper;
import pt.webdetails.cda.dataaccess.DefaultCubeFileProviderSetter;
import pt.webdetails.cda.dataaccess.DefaultDataAccessUtils;
import pt.webdetails.cda.dataaccess.ICubeFileProviderSetter;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.messaging.IEventPublisher;
import pt.webdetails.cpf.messaging.PluginEvent;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public abstract class BaseCdaEnvironment
implements ICdaEnvironment {
    protected static Log logger = LogFactory.getLog(BaseCdaEnvironment.class);
    private static final String RESOURCES_DIR = "resources";
    private static final String COMPONENTS_DEF = "components.properties";
    private static final String BASE_PROPERTIES = "cda.properties";
    private ICdaBeanFactory beanFactory;
    private HierarchicalConfiguration config;

    public BaseCdaEnvironment() throws InitializationException {
        this.init();
    }

    public BaseCdaEnvironment(ICdaBeanFactory factory) throws InitializationException {
        this.init(factory);
    }

    @Override
    public void init() throws InitializationException {
        this.initBeanFactory();
    }

    public void init(ICdaBeanFactory factory) {
        this.beanFactory = factory;
    }

    private void initBeanFactory() throws InitializationException {
        this.beanFactory = new CoreBeanFactory();
    }

    @Override
    public IQueryCache getQueryCache() {
        try {
            String id = "IQueryCache";
            if (this.beanFactory.containsBean(id)) {
                return (IQueryCache)this.beanFactory.getBean(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot get bean IQueryCache. Using EHCacheQueryCache", (Throwable)e);
        }
        return new EHCacheQueryCache();
    }

    @Override
    public FormulaContext getFormulaContext() {
        return new DefaultFormulaContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getCdaComponents() {
        try {
            IReadAccess sysRead = this.getRepo().getPluginSystemReader(RESOURCES_DIR);
            Properties pr = new Properties();
            InputStream propertiesFile = null;
            try {
                propertiesFile = sysRead.getFileInputStream(COMPONENTS_DEF);
                pr.load(propertiesFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)propertiesFile);
            }
            return pr;
        }
        catch (Exception e) {
            logger.error((Object)"Cannot load components.properties");
            return new Properties();
        }
    }

    @Override
    public IEventPublisher getEventPublisher() {
        String id = "IEventPublisher";
        if (this.beanFactory != null && this.beanFactory.containsBean(id)) {
            return (IEventPublisher)this.beanFactory.getBean(id);
        }
        return new IEventPublisher(){

            public void publish(PluginEvent arg0) {
                logger.debug((Object)("Event: " + arg0.getKey() + " : " + arg0.getName() + "\n" + arg0.toString()));
            }
        };
    }

    @Override
    public IMondrianRoleMapper getMondrianRoleMapper() {
        String id = "IMondrianRoleMapper";
        if (this.beanFactory != null && this.beanFactory.containsBean(id)) {
            return (IMondrianRoleMapper)this.beanFactory.getBean(id);
        }
        logger.warn((Object)"Cannot get bean IMondrianRoleMapper. Using pseudo MondrianRoleMapper");
        return new IMondrianRoleMapper(){

            @Override
            public String getRoles(String catalog) {
                return "";
            }
        };
    }

    @Override
    public ICubeFileProviderSetter getCubeFileProviderSetter() {
        try {
            String id = "ICubeFileProviderSetter";
            if (this.beanFactory != null && this.beanFactory.containsBean(id)) {
                return (ICubeFileProviderSetter)this.beanFactory.getBean(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot get bean ICubeFileProviderSetter. Using DefaultCubeFileProviderSetter", (Throwable)e);
        }
        return new DefaultCubeFileProviderSetter();
    }

    @Override
    public IDataAccessUtils getDataAccessUtils() {
        try {
            String id = "IDataAccessUtils";
            if (this.beanFactory != null && this.beanFactory.containsBean(id)) {
                return (IDataAccessUtils)this.beanFactory.getBean(id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot get bean IDataAccessUtils. Using DefaultDataAccessUtils", (Throwable)e);
        }
        return new DefaultDataAccessUtils();
    }

    @Override
    public IContentAccessFactory getRepo() {
        return PluginEnvironment.repository();
    }

    @Override
    public synchronized Configuration getBaseConfig() {
        if (this.config == null) {
            this.config = new HierarchicalConfiguration();
            IReadAccess sysReader = this.getRepo().getPluginSystemReader("");
            if (sysReader.fileExists(BASE_PROPERTIES)) {
                PropertyFileConfiguration properties = new PropertyFileConfiguration();
                try {
                    properties.load(sysReader.getFileInputStream(BASE_PROPERTIES));
                    this.config.insertConfiguration((HierarchicalConfiguration)properties);
                    logger.debug((Object)"cda.properties read ok.");
                }
                catch (IOException e) {
                    logger.error((Object)"Error reading cda.properties", (Throwable)e);
                }
            } else {
                logger.error((Object)"Unable to load cda.properties");
            }
        }
        return this.config;
    }
}

