/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import javax.xml.validation.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowAppParser;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public abstract class LiteWorkflowLib
implements WorkflowLib {
    private Schema schema;
    private Class<? extends ControlNodeHandler> controlHandlerClass;
    private Class<? extends DecisionNodeHandler> decisionHandlerClass;
    private Class<? extends ActionNodeHandler> actionHandlerClass;

    public LiteWorkflowLib(Schema schema, Class<? extends ControlNodeHandler> controlNodeHandler, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass) {
        this.schema = schema;
        this.controlHandlerClass = controlNodeHandler;
        this.decisionHandlerClass = decisionHandlerClass;
        this.actionHandlerClass = actionHandlerClass;
    }

    @Override
    public WorkflowApp parseDef(String appXml, Configuration jobConf) throws WorkflowException {
        ParamChecker.notEmpty(appXml, "appXml");
        return new LiteWorkflowAppParser(this.schema, this.controlHandlerClass, this.decisionHandlerClass, this.actionHandlerClass).validateAndParse(new StringReader(appXml), jobConf);
    }

    @Override
    public WorkflowInstance createInstance(WorkflowApp app, Configuration conf) throws WorkflowException {
        ParamChecker.notNull(app, "app");
        String jobId = Services.get().get(UUIDService.class).generateId(UUIDService.ApplicationType.WORKFLOW);
        return new LiteWorkflowInstance((LiteWorkflowApp)app, conf, jobId);
    }

    @Override
    public WorkflowInstance createInstance(WorkflowApp app, Configuration conf, String wfId, Map<String, Date> actionEndTimes) throws WorkflowException {
        ParamChecker.notNull(app, "app");
        ParamChecker.notNull(wfId, "wfId");
        return new LiteWorkflowInstance((LiteWorkflowApp)app, conf, wfId, actionEndTimes);
    }
}

