/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseAdminServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.json.simple.JSONObject;

public class V0AdminServlet
extends BaseAdminServlet {
    private static final long serialVersionUID = 1L;
    private static final String INSTRUMENTATION_NAME = "v0admin";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[6];

    public V0AdminServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
        this.modeTag = "safemode";
    }

    @Override
    protected void populateOozieMode(JSONObject json) {
        if (Services.get().getSystemMode() != OozieClient.SYSTEM_MODE.NORMAL) {
            json.put((Object)"safeMode", (Object)true);
        } else {
            json.put((Object)"safeMode", (Object)false);
        }
    }

    @Override
    protected void setOozieMode(HttpServletRequest request, HttpServletResponse response, String resourceName) throws XServletException {
        if (!resourceName.equals("status")) {
            throw new XServletException(400, ErrorCode.E0301, resourceName);
        }
        boolean safeMode = Boolean.parseBoolean(request.getParameter(this.modeTag));
        OozieClient.SYSTEM_MODE sysMode = safeMode ? OozieClient.SYSTEM_MODE.NOWEBSERVICE : OozieClient.SYSTEM_MODE.NORMAL;
        System.out.println(this.modeTag + " DDDD " + sysMode);
        Services.get().setSystemMode(sysMode);
        response.setStatus(200);
    }

    @Override
    protected void getQueueDump(JSONObject json) throws XServletException {
        throw new XServletException(400, ErrorCode.E0301, "cannot get queue dump");
    }

    @Override
    protected JsonBean getJMSConnectionInfo(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v0");
    }

    @Override
    protected Map<String, String> getOozieURLs() throws XServletException {
        throw new XServletException(400, ErrorCode.E0302, "Not supported in v1");
    }

    static {
        V0AdminServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("status", Arrays.asList("PUT", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("safemode", Boolean.class, true, Arrays.asList("PUT"))));
        V0AdminServlet.RESOURCES_INFO[1] = new JsonRestServlet.ResourceInfo("os-env", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V0AdminServlet.RESOURCES_INFO[2] = new JsonRestServlet.ResourceInfo("java-sys-properties", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V0AdminServlet.RESOURCES_INFO[3] = new JsonRestServlet.ResourceInfo("configuration", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V0AdminServlet.RESOURCES_INFO[4] = new JsonRestServlet.ResourceInfo("instrumentation", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V0AdminServlet.RESOURCES_INFO[5] = new JsonRestServlet.ResourceInfo("build-version", Arrays.asList("GET"), Collections.EMPTY_LIST);
    }
}

