/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class ShareLibService
implements Service,
Instrumentable {
    public static final String LAUNCHERJAR_LIB_RETENTION = "oozie.service.ShareLibService.temp.sharelib.retention.days";
    public static final String SHARELIB_MAPPING_FILE = "oozie.service.ShareLibService.mapping.file";
    public static final String SHIP_LAUNCHER_JAR = "oozie.action.ship.launcher.jar";
    public static final String PURGE_INTERVAL = "oozie.service.ShareLibService.purge.interval";
    private static final String PERMISSION_STRING = "-rwxr-xr-x";
    public static final String LAUNCHER_PREFIX = "launcher_";
    public static final String SHARED_LIB_PREFIX = "lib_";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private Services services;
    private Map<String, List<Path>> shareLibMap = new HashMap<String, List<Path>>();
    private Map<String, List<Path>> launcherLibMap = new HashMap<String, List<Path>>();
    private static XLog LOG = XLog.getLog(ShareLibService.class);
    private String sharelibMappingFile;
    private boolean isShipLauncherEnabled = false;
    public static String SHARE_LIB_CONF_PREFIX = "oozie";
    private boolean shareLibLoadAttempted = false;
    private String sharelibMetaFileOldTimeStamp;
    private String sharelibDirOld;
    FileSystem fs;
    final long retentionTime = 86400000 * Services.get().getConf().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7);

    @Override
    public void init(Services services) throws ServiceException {
        this.services = services;
        this.sharelibMappingFile = services.getConf().get(SHARELIB_MAPPING_FILE, "");
        this.isShipLauncherEnabled = services.getConf().getBoolean(SHIP_LAUNCHER_JAR, false);
        Path launcherlibPath = this.getLauncherlibPath();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        URI uri = launcherlibPath.toUri();
        try {
            this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
            this.updateLauncherLib();
            this.updateShareLib();
        }
        catch (IOException ioe) {
            ServiceException se = new ServiceException(ErrorCode.E0104, this.getClass().getName(), "Not able to cache sharelib.  An Admin needs to install the sharelib with oozie-setup.sh and issue the 'oozie admin' CLI command to update the sharelib", ioe);
            LOG.error(se);
        }
        Runnable purgeLibsRunnable = new Runnable(){

            @Override
            public void run() {
                System.out.flush();
                try {
                    if (Services.get().get(JobsConcurrencyService.class).isFirstServer()) {
                        Date current = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
                        ShareLibService.this.purgeLibs(ShareLibService.this.fs, ShareLibService.LAUNCHER_PREFIX, current);
                        ShareLibService.this.purgeLibs(ShareLibService.this.fs, ShareLibService.SHARED_LIB_PREFIX, current);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"There was an issue purging the sharelib", e);
                }
            }
        };
        services.get(SchedulerService.class).schedule(purgeLibsRunnable, 10L, (long)(services.getConf().getInt(PURGE_INTERVAL, 1) * 60 * 60 * 24), SchedulerService.Unit.SEC);
    }

    private void updateLauncherLib() throws IOException {
        if (this.isShipLauncherEnabled) {
            Path launcherlibPath;
            if (this.fs == null) {
                launcherlibPath = this.getLauncherlibPath();
                HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
                URI uri = launcherlibPath.toUri();
                this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
            }
            launcherlibPath = this.getLauncherlibPath();
            this.setupLauncherLibPath(this.fs, launcherlibPath);
            this.recursiveChangePermissions(this.fs, launcherlibPath, FsPermission.valueOf((String)PERMISSION_STRING));
        }
    }

    private void setupLauncherLibPath(FileSystem fs, Path tmpLauncherLibPath) throws IOException {
        ActionService actionService = Services.get().get(ActionService.class);
        List<Class> classes = JavaActionExecutor.getCommonLauncherClasses();
        Path baseDir = new Path(tmpLauncherLibPath, "oozie");
        this.copyJarContainingClasses(classes, fs, baseDir, "oozie");
        Set<String> actionTypes = actionService.getActionTypes();
        for (String key : actionTypes) {
            JavaActionExecutor jexecutor;
            ActionExecutor executor = actionService.getExecutor(key);
            if (!(executor instanceof JavaActionExecutor) || (classes = (jexecutor = (JavaActionExecutor)executor).getLauncherClasses()) == null) continue;
            String type = executor.getType();
            Path executorDir = new Path(tmpLauncherLibPath, type);
            this.copyJarContainingClasses(classes, fs, executorDir, type);
        }
    }

    private void recursiveChangePermissions(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        fs.setPermission(path, fsPerm);
        FileStatus[] filesStatus = fs.listStatus(path);
        for (int i = 0; i < filesStatus.length; ++i) {
            Path p = filesStatus[i].getPath();
            if (filesStatus[i].isDir()) {
                this.recursiveChangePermissions(fs, p, fsPerm);
                continue;
            }
            fs.setPermission(p, fsPerm);
        }
    }

    private void copyJarContainingClasses(List<Class> classes, FileSystem fs, Path executorDir, String type) throws IOException {
        fs.mkdirs(executorDir);
        HashSet<String> localJarSet = new HashSet<String>();
        for (Class c : classes) {
            String localJar = this.findContainingJar(c);
            if (localJar != null) {
                localJarSet.add(localJar);
                continue;
            }
            throw new IOException("No jar containing " + c + " found");
        }
        ArrayList<Path> listOfPaths = new ArrayList<Path>();
        for (String localJarStr : localJarSet) {
            File localJar = new File(localJarStr);
            fs.copyFromLocalFile(new Path(localJar.getPath()), executorDir);
            Path path = new Path(executorDir, localJar.getName());
            listOfPaths.add(path);
            LOG.info(localJar.getName() + " uploaded to " + executorDir.toString());
        }
        this.launcherLibMap.put(type, listOfPaths);
    }

    private void getPathRecursively(FileSystem fs, Path rootDir, List<Path> listOfPaths) throws IOException {
        if (rootDir == null) {
            return;
        }
        FileStatus[] status = fs.listStatus(rootDir);
        if (status == null) {
            LOG.info("Shared lib " + rootDir + " doesn't exist, not adding to cache");
            return;
        }
        for (FileStatus file : status) {
            if (file.isDir()) {
                this.getPathRecursively(fs, file.getPath(), listOfPaths);
                continue;
            }
            listOfPaths.add(file.getPath());
        }
    }

    public Map<String, List<Path>> getShareLib() {
        return this.shareLibMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Path> getShareLibJars(String actionKey) throws IOException {
        if (!this.shareLibMap.isEmpty() || this.shareLibLoadAttempted) return this.shareLibMap.get(actionKey);
        Class<ShareLibService> clazz = ShareLibService.class;
        synchronized (ShareLibService.class) {
            if (!this.shareLibMap.isEmpty()) return this.shareLibMap.get(actionKey);
            this.updateShareLib();
            this.shareLibLoadAttempted = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.shareLibMap.get(actionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List<Path> getSystemLibJars(String actionKey) throws IOException {
        List<Path> returnList = new ArrayList<Path>();
        if (this.isShipLauncherEnabled) {
            if (this.launcherLibMap.isEmpty()) {
                Class<ShareLibService> clazz = ShareLibService.class;
                // MONITORENTER : org.apache.oozie.service.ShareLibService.class
                if (this.launcherLibMap.isEmpty()) {
                    this.updateLauncherLib();
                }
                // MONITOREXIT : clazz
            }
            returnList = this.launcherLibMap.get(actionKey);
        }
        if (!actionKey.equals("oozie")) return returnList;
        List<Path> sharelibList = this.getShareLibJars(actionKey);
        if (sharelibList == null) return returnList;
        returnList.addAll(sharelibList);
        return returnList;
    }

    @VisibleForTesting
    protected String findContainingJar(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(classFile);
            while (itr.hasMoreElements()) {
                String toReturn;
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol()) || !(toReturn = url.getPath()).startsWith("file:")) continue;
                toReturn = toReturn.substring("file:".length());
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                toReturn = toReturn.replaceAll("!.*$", "");
                return toReturn;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return null;
    }

    private void purgeLibs(FileSystem fs, final String prefix, final Date current) throws IOException {
        Path executorLibBasePath = this.services.get(WorkflowAppService.class).getSystemLibPath();
        PathFilter directoryFilter = new PathFilter(){

            public boolean accept(Path path) {
                if (path.getName().startsWith(prefix)) {
                    String name = path.getName();
                    String time = name.substring(prefix.length());
                    Date d = null;
                    try {
                        d = dateFormat.parse(time);
                    }
                    catch (ParseException e) {
                        return false;
                    }
                    return current.getTime() - d.getTime() > ShareLibService.this.retentionTime;
                }
                return false;
            }
        };
        FileStatus[] dirList = fs.listStatus(executorLibBasePath, directoryFilter);
        Arrays.sort(dirList, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                return o2.getPath().getName().compareTo(o1.getPath().getName());
            }
        });
        for (int i = 1; i < dirList.length; ++i) {
            Path dirPath = dirList[i].getPath();
            fs.delete(dirPath, true);
            LOG.info("Deleted old launcher jar lib directory {0}", dirPath.getName());
        }
    }

    @Override
    public void destroy() {
        this.shareLibMap.clear();
        this.launcherLibMap.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ShareLibService.class;
    }

    public Map<String, String> updateShareLib() throws IOException {
        HashMap<String, String> status = new HashMap<String, String>();
        if (this.fs == null) {
            Path launcherlibPath = this.getLauncherlibPath();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = launcherlibPath.toUri();
            this.fs = FileSystem.get((Configuration)has.createJobConf(uri.getAuthority()));
        }
        HashMap<String, List<Path>> tempShareLibMap = new HashMap<String, List<Path>>();
        if (!StringUtils.isEmpty((String)this.sharelibMappingFile)) {
            String sharelibMetaFileNewTimeStamp = JsonUtils.formatDateRfc822((Date)new Date(this.fs.getFileStatus(new Path(this.sharelibMappingFile)).getModificationTime()), (String)"GMT");
            this.loadShareLibMetaFile(tempShareLibMap, this.sharelibMappingFile);
            status.put("sharelibMetaFile", this.sharelibMappingFile);
            status.put("sharelibMetaFileNewTimeStamp", sharelibMetaFileNewTimeStamp);
            status.put("sharelibMetaFileOldTimeStamp", this.sharelibMetaFileOldTimeStamp);
            this.sharelibMetaFileOldTimeStamp = sharelibMetaFileNewTimeStamp;
        } else {
            Path shareLibpath = this.getLatestLibPath(this.services.get(WorkflowAppService.class).getSystemLibPath(), SHARED_LIB_PREFIX);
            this.loadShareLibfromDFS(tempShareLibMap, shareLibpath);
            if (shareLibpath != null) {
                status.put("sharelibDirNew", shareLibpath.toString());
                status.put("sharelibDirOld", this.sharelibDirOld);
                this.sharelibDirOld = shareLibpath.toString();
            }
        }
        this.shareLibMap = tempShareLibMap;
        return status;
    }

    private void loadShareLibfromDFS(Map<String, List<Path>> shareLibMap, Path shareLibpath) throws IOException {
        if (shareLibpath == null) {
            LOG.info("No share lib directory found");
            return;
        }
        FileStatus[] dirList = this.fs.listStatus(shareLibpath);
        if (dirList == null) {
            return;
        }
        for (FileStatus dir : dirList) {
            if (!dir.isDir()) continue;
            ArrayList<Path> listOfPaths = new ArrayList<Path>();
            this.getPathRecursively(this.fs, dir.getPath(), listOfPaths);
            shareLibMap.put(dir.getPath().getName(), listOfPaths);
            LOG.info("Share lib for " + dir.getPath().getName() + ":" + listOfPaths);
        }
    }

    private void loadShareLibMetaFile(Map<String, List<Path>> shareLibMap, String sharelibFileMapping) throws IOException {
        Path shareFileMappingPath = new Path(sharelibFileMapping);
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        FileSystem filesystem = FileSystem.get((Configuration)has.createJobConf(shareFileMappingPath.toUri().getAuthority()));
        Properties prop = new Properties();
        prop.load((InputStream)filesystem.open(new Path(sharelibFileMapping)));
        for (Object keyObject : prop.keySet()) {
            String key = (String)keyObject;
            if (key.toLowerCase().startsWith(SHARE_LIB_CONF_PREFIX)) {
                String mapKey = key.substring(SHARE_LIB_CONF_PREFIX.length() + 1);
                String[] pathList = ((String)prop.get(key)).split(",");
                ArrayList<Path> listOfPaths = new ArrayList<Path>();
                for (String dfsPath : pathList) {
                    this.getPathRecursively(this.fs, new Path(dfsPath), listOfPaths);
                }
                shareLibMap.put(mapKey, listOfPaths);
                LOG.info("Share lib for " + mapKey + ":" + listOfPaths);
                continue;
            }
            LOG.info(" Not adding " + key + " to sharelib, not prefix with " + SHARE_LIB_CONF_PREFIX);
        }
    }

    private Path getLauncherlibPath() {
        String formattedDate = dateFormat.format(Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime());
        Path tmpLauncherLibPath = new Path(this.services.get(WorkflowAppService.class).getSystemLibPath(), LAUNCHER_PREFIX + formattedDate);
        return tmpLauncherLibPath;
    }

    public Path getLatestLibPath(Path rootDir, final String prefix) throws IOException {
        FileStatus[] files;
        Date max = new Date(0L);
        Path path = null;
        PathFilter directoryFilter = new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(prefix);
            }
        };
        for (FileStatus file : files = this.fs.listStatus(rootDir, directoryFilter)) {
            String name = file.getPath().getName().toString();
            String time = name.substring(prefix.length());
            Date d = null;
            try {
                d = dateFormat.parse(time);
            }
            catch (ParseException e) {
                continue;
            }
            if (d.compareTo(max) <= 0) continue;
            path = file.getPath();
            max = d;
        }
        return path;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("libs", "sharelib.source", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMappingFile)) {
                    return ShareLibService.SHARELIB_MAPPING_FILE;
                }
                return "oozie.service.WorkflowAppService.system.libpath";
            }
        });
        instr.addVariable("libs", "sharelib.mapping.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMappingFile)) {
                    return ShareLibService.this.sharelibMappingFile;
                }
                return "(none)";
            }
        });
        instr.addVariable("libs", "sharelib.system.libpath", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                String sharelibPath = "(unavailable)";
                try {
                    Path libPath = ShareLibService.this.getLatestLibPath(ShareLibService.this.services.get(WorkflowAppService.class).getSystemLibPath(), ShareLibService.SHARED_LIB_PREFIX);
                    if (libPath != null) {
                        sharelibPath = libPath.toUri().toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return sharelibPath;
            }
        });
        instr.addVariable("libs", "sharelib.mapping.file.timestamp", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                if (!StringUtils.isEmpty((String)ShareLibService.this.sharelibMetaFileOldTimeStamp)) {
                    return ShareLibService.this.sharelibMetaFileOldTimeStamp;
                }
                return "(none)";
            }
        });
        instr.addVariable("libs", "sharelib.keys", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                Map<String, List<Path>> shareLib = ShareLibService.this.getShareLib();
                if (shareLib != null && !shareLib.isEmpty()) {
                    Set<String> keySet = shareLib.keySet();
                    return keySet.toString();
                }
                return "(unavailable)";
            }
        });
        instr.addVariable("libs", "launcherlib.system.libpath", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ShareLibService.this.getLauncherlibPath().toUri().toString();
            }
        });
    }
}

