/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class WorkflowActionSubsetGetJPAExecutor
implements JPAExecutor<List<WorkflowActionBean>> {
    private final String wfId;
    private final int start;
    private final int length;

    public WorkflowActionSubsetGetJPAExecutor(String wfId, int start, int length) {
        ParamChecker.notNull(wfId, "wfJobId");
        this.wfId = wfId;
        this.start = start;
        this.length = length;
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        List actions;
        ArrayList actionList = new ArrayList();
        try {
            Query q = em.createNamedQuery("GET_ACTIONS_FOR_WORKFLOW");
            OpenJPAPersistence.cast((Query)q);
            q.setParameter("wfId", (Object)this.wfId);
            q.setFirstResult(this.start - 1);
            q.setMaxResults(this.length);
            actions = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0605, "null", e);
        }
        return actions;
    }

    @Override
    public String getName() {
        return "WorkflowActionSubsetGetJPAExecutor";
    }
}

