/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;

public class BatchQueryExecutor {
    private static BatchQueryExecutor instance = new BatchQueryExecutor();
    private static JPAService jpaService;

    private BatchQueryExecutor() {
        Services services = Services.get();
        if (services != null) {
            jpaService = services.get(JPAService.class);
        }
    }

    public static BatchQueryExecutor getInstance() {
        if (instance == null) {
            instance = new BatchQueryExecutor();
        }
        return instance;
    }

    public void executeBatchInsertUpdateDelete(Collection<JsonBean> insertList, Collection<UpdateEntry> updateList, Collection<JsonBean> deleteList) throws JPAExecutorException {
        ArrayList<JPAService.QueryEntry> queryList = new ArrayList<JPAService.QueryEntry>();
        EntityManager em = jpaService.getEntityManager();
        if (updateList != null) {
            for (UpdateEntry entry : updateList) {
                Query query = null;
                JsonBean bean = entry.getBean();
                if (bean instanceof WorkflowJobBean) {
                    query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((WorkflowJobQueryExecutor.WorkflowJobQuery)((Object)entry.getQueryName()), (WorkflowJobBean)entry.getBean(), em);
                } else if (bean instanceof WorkflowActionBean) {
                    query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((WorkflowActionQueryExecutor.WorkflowActionQuery)((Object)entry.getQueryName()), (WorkflowActionBean)entry.getBean(), em);
                } else if (bean instanceof CoordinatorJobBean) {
                    query = CoordJobQueryExecutor.getInstance().getUpdateQuery((CoordJobQueryExecutor.CoordJobQuery)((Object)entry.getQueryName()), (CoordinatorJobBean)entry.getBean(), em);
                } else if (bean instanceof CoordinatorActionBean) {
                    query = CoordActionQueryExecutor.getInstance().getUpdateQuery((CoordActionQueryExecutor.CoordActionQuery)((Object)entry.getQueryName()), (CoordinatorActionBean)entry.getBean(), em);
                } else if (bean instanceof BundleJobBean) {
                    query = BundleJobQueryExecutor.getInstance().getUpdateQuery((BundleJobQueryExecutor.BundleJobQuery)((Object)entry.getQueryName()), (BundleJobBean)entry.getBean(), em);
                } else if (bean instanceof BundleActionBean) {
                    query = BundleActionQueryExecutor.getInstance().getUpdateQuery((BundleActionQueryExecutor.BundleActionQuery)((Object)entry.getQueryName()), (BundleActionBean)entry.getBean(), em);
                } else if (bean instanceof SLARegistrationBean) {
                    query = SLARegistrationQueryExecutor.getInstance().getUpdateQuery((SLARegistrationQueryExecutor.SLARegQuery)((Object)entry.getQueryName()), (SLARegistrationBean)entry.getBean(), em);
                } else if (bean instanceof SLASummaryBean) {
                    query = SLASummaryQueryExecutor.getInstance().getUpdateQuery((SLASummaryQueryExecutor.SLASummaryQuery)((Object)entry.getQueryName()), (SLASummaryBean)entry.getBean(), em);
                } else {
                    throw new JPAExecutorException(ErrorCode.E0603, "BatchQueryExecutor faield to construct a query");
                }
                queryList.add(new JPAService.QueryEntry(entry.getQueryName(), query));
            }
        }
        jpaService.executeBatchInsertUpdateDelete(insertList, queryList, deleteList, em);
    }

    @VisibleForTesting
    public static void destroy() {
        if (instance != null) {
            jpaService = null;
            instance = null;
        }
    }

    public static class UpdateEntry<E extends Enum<E>> {
        E namedQuery;
        JsonBean bean;

        public UpdateEntry(E namedQuery, JsonBean bean) {
            this.bean = bean;
            this.namedQuery = namedQuery;
        }

        public JsonBean getBean() {
            return this.bean;
        }

        public E getQueryName() {
            return this.namedQuery;
        }
    }
}

