/*
 * Decompiled with CFR 0.152.
 */
package rat.document.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import rat.document.IDocument;
import rat.document.IDocumentCollection;
import rat.document.IFileUnarchiver;
import rat.document.impl.DocumentImplUtils;

public class FileDocument
implements IDocument {
    private final File file;
    private final String name;
    private IFileUnarchiver unarchiver;

    public FileDocument(File file, IFileUnarchiver unarchiver) {
        this.file = file;
        this.unarchiver = unarchiver;
        this.name = DocumentImplUtils.toName(file);
    }

    public IDocumentCollection readArchive() throws IOException {
        IDocumentCollection result = this.unarchiver.unarchive(this.file);
        return result;
    }

    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }

    public String getName() {
        return this.name;
    }
}

