/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PathExceptions {

    public static class PathOperationException
    extends PathExistsException {
        static final long serialVersionUID = 0L;

        public PathOperationException(String path) {
            super(path, "Operation not supported");
        }
    }

    public static class PathPermissionException
    extends PathIOException {
        static final long serialVersionUID = 0L;

        public PathPermissionException(String path) {
            super(path, "Operation not permitted");
        }
    }

    public static class PathAccessDeniedException
    extends PathIOException {
        static final long serialVersionUID = 0L;

        public PathAccessDeniedException(String path) {
            super(path, "Permission denied");
        }
    }

    public static class PathIsNotEmptyDirectoryException
    extends PathExistsException {
        public PathIsNotEmptyDirectoryException(String path) {
            super(path, "Directory is not empty");
        }
    }

    public static class PathIsNotDirectoryException
    extends PathExistsException {
        static final long serialVersionUID = 0L;

        public PathIsNotDirectoryException(String path) {
            super(path, "Is not a directory");
        }
    }

    public static class PathIsDirectoryException
    extends PathExistsException {
        static final long serialVersionUID = 0L;

        public PathIsDirectoryException(String path) {
            super(path, "Is a directory");
        }
    }

    public static class PathExistsException
    extends PathIOException {
        static final long serialVersionUID = 0L;

        public PathExistsException(String path) {
            super(path, "File exists");
        }

        protected PathExistsException(String path, String error) {
            super(path, error);
        }
    }

    public static class PathNotFoundException
    extends PathIOException {
        static final long serialVersionUID = 0L;

        public PathNotFoundException(String path) {
            super(path, "No such file or directory");
        }
    }

    public static class PathIOException
    extends IOException {
        static final long serialVersionUID = 0L;
        private static final String EIO = "Input/output error";
        private String operation;
        private String path;
        private String targetPath;

        public PathIOException(String path) {
            this(path, EIO, null);
        }

        public PathIOException(String path, Throwable cause) {
            this(path, EIO, cause);
        }

        public PathIOException(String path, String error) {
            this(path, error, null);
        }

        protected PathIOException(String path, String error, Throwable cause) {
            super(error, cause);
            this.path = path;
        }

        @Override
        public String getMessage() {
            StringBuilder message = new StringBuilder();
            if (this.operation != null) {
                message.append(this.operation + " ");
            }
            message.append(this.formatPath(this.path));
            if (this.targetPath != null) {
                message.append(" to " + this.formatPath(this.targetPath));
            }
            message.append(": " + super.getMessage());
            if (this.getCause() != null) {
                message.append(": " + this.getCause().getMessage());
            }
            return message.toString();
        }

        public Path getPath() {
            return new Path(this.path);
        }

        public Path getTargetPath() {
            return this.targetPath != null ? new Path(this.targetPath) : null;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        private String formatPath(String path) {
            return "`" + path + "'";
        }
    }
}

